/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.io.passthrough;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.io.IFileTransferCreator;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughFileTransferCreator;
import java.net.URI;

public class PassthroughCapabilities {
    public static final String SCHEME = "bypass";

    public Class<? extends IFileTransferCreator>[] getFileTransferCreators() {
        return new Class[]{PassthroughFileTransferCreator.class};
    }

    public static void register(Configuration conf) {
        IFileTransferEngine fte = conf.getFileTransferEngine();
        String[] protocols = fte.listProtocols();
        boolean already_registered = false;
        for (String protocol : protocols) {
            if (!protocol.equals(SCHEME)) continue;
            already_registered = true;
            break;
        }
        if (!already_registered) {
            fte.registerFileTransferCreator((IFileTransferCreator)new PassthroughFileTransferCreator(conf));
        }
        protocols = fte.listProtocols();
    }

    public static boolean isValidUri(URI uri) {
        return SCHEME.equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isValidUri(String uri) {
        String scheme = uri.substring(0, SCHEME.length());
        return SCHEME.equalsIgnoreCase(scheme);
    }
}

