/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.g3bridge;

import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeSubmitter;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.DeleteRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetFinishedRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetFinishedResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridAlgRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridAlgResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridDataRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridDataResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetOutputRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetOutputResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetStatusRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetStatusResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetVersionResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.Job;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.JobOutput;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.JobStatus;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.SubmitRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.SubmitResponseDocument;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.log4j.Logger;

public class MockSubmitterImpl
implements G3BridgeSubmitter {
    private static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi", MockSubmitterImpl.class);
    public static final Map<String, Job> jobMap = new HashMap<String, Job>();
    public static final Map<String, Long> finishTime = new HashMap<String, Long>();
    private static final Random rand = new Random();

    @Override
    public SubmitResponseDocument submit(SubmitRequestDocument request) {
        System.out.println("*** submit req " + request);
        Job[] jobs = request.getSubmitRequest().getJobArray();
        SubmitResponseDocument resp = SubmitResponseDocument.Factory.newInstance();
        resp.addNewSubmitResponse();
        for (Job j : jobs) {
            String uid = UUID.randomUUID().toString();
            resp.getSubmitResponse().addJobid(uid);
            jobMap.put(uid, j);
            Long duration = new Long(2000 + rand.nextInt(20000));
            finishTime.put(uid, System.currentTimeMillis() + duration);
            log.info((Object)("Accepted job " + uid + " duration will be " + duration / 1000L + " sec."));
        }
        return resp;
    }

    @Override
    public GetStatusResponseDocument getStatus(GetStatusRequestDocument request) {
        System.out.println("*** getStatus req " + request);
        GetStatusResponseDocument resp = GetStatusResponseDocument.Factory.newInstance();
        resp.addNewGetStatusResponse();
        String[] ids = request.getGetStatusRequest().getJobidArray();
        if (ids != null && ids.length > 0) {
            for (String jobID : ids) {
                resp.getGetStatusResponse().addStatus(this.getStatus(jobID));
            }
        }
        return resp;
    }

    private JobStatus.Enum getStatus(String jobID) {
        JobStatus.Enum status = JobStatus.UNKNOWN;
        Long finish = finishTime.get(jobID);
        if (finish != null) {
            status = System.currentTimeMillis() > finish ? JobStatus.FINISHED : JobStatus.RUNNING;
        }
        return status;
    }

    @Override
    public void delete(DeleteRequestDocument request) {
        for (String jobID : request.getDeleteRequest().getJobidArray()) {
            jobMap.remove(jobID);
            finishTime.remove(jobID);
        }
    }

    @Override
    public GetOutputResponseDocument getOutput(GetOutputRequestDocument request) {
        GetOutputResponseDocument res = GetOutputResponseDocument.Factory.newInstance();
        for (String id : request.getGetOutputRequest().getJobidArray()) {
            JobOutput p = res.addNewGetOutputResponse().addNewOutput();
        }
        return res;
    }

    @Override
    public GetFinishedResponseDocument getFinished(GetFinishedRequestDocument request) {
        System.out.println("*** getFinished req " + request);
        GetFinishedResponseDocument resp = GetFinishedResponseDocument.Factory.newInstance();
        resp.addNewGetFinishedResponse();
        for (String id : jobMap.keySet()) {
            if (this.getStatus(id) != JobStatus.FINISHED) continue;
            resp.getGetFinishedResponse().addJobid(id);
        }
        return resp;
    }

    @Override
    public GetGridDataResponseDocument getGridData(GetGridDataRequestDocument request) {
        return null;
    }

    @Override
    public GetGridAlgResponseDocument getGridAlg(GetGridAlgRequestDocument request) {
        return null;
    }

    @Override
    public GetVersionResponseDocument version() {
        GetVersionResponseDocument resp = GetVersionResponseDocument.Factory.newInstance();
        resp.setGetVersionResponse("MOCK IMPL 1.0");
        return resp;
    }
}

