/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.g3bridge;

import de.pc2.unicore.edgi.xnjs.g3bridge.LogicalFileDescription;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String alg;
    public String grid;
    public String args;
    public List<LogicalFileDescription> inputs;
    public List<LogicalFileDescription> outputs;
    public List<String> envs;
    public String tag;
    public String id;
    public Status status;

    public JobDescription(String alg, String grid, String args, List<LogicalFileDescription> inputs, List<String> outputs, List<String> envs, String tag) {
        this.alg = alg;
        this.grid = grid;
        this.args = args != null ? args : "";
        this.inputs = new ArrayList<LogicalFileDescription>();
        if (inputs != null) {
            for (LogicalFileDescription lfd : inputs) {
                this.inputs.add(lfd);
            }
        }
        this.outputs = new ArrayList<LogicalFileDescription>();
        if (outputs != null) {
            for (String name : outputs) {
                this.outputs.add(new LogicalFileDescription(name));
            }
        }
        this.envs = new ArrayList<String>();
        if (envs != null) {
            for (String env : envs) {
                this.envs.add(env);
            }
        }
        this.tag = tag;
        this.id = null;
        this.status = Status.UNSET;
    }

    public JobDescription(String id) {
        this.grid = null;
        this.alg = null;
        this.args = null;
        this.inputs = null;
        this.outputs = null;
        this.envs = null;
        this.tag = null;
        this.id = id;
        this.status = Status.UNSET;
    }

    public JobDescription(JobDescription other) {
        this.alg = other.alg;
        this.grid = other.grid;
        this.args = other.args;
        this.inputs = other.inputs;
        this.outputs = other.outputs;
        this.envs = other.envs;
        this.tag = other.tag;
        this.id = other.id;
        this.status = other.status;
    }

    public String toString() {
        return this.id + ", " + (Object)((Object)this.status);
    }

    void println(PrintStream ps) {
        ps.printf("JobID '%s' status '%s'\n", new Object[]{this.id, this.status});
        ps.printf("  Grid '%s', Alg '%s', Args '%s'\n", this.grid, this.alg, this.args);
        for (LogicalFileDescription logicalFileDescription : this.inputs) {
            ps.printf("  inputs name '%s', url '%s', md5 '%s', size '%d'\n", logicalFileDescription.logicalName, logicalFileDescription.url, logicalFileDescription.md5, logicalFileDescription.size);
        }
        for (LogicalFileDescription logicalFileDescription : this.outputs) {
            ps.printf("  outputs name '%s', url '%s', md5 '%s', size '%d'\n", logicalFileDescription.logicalName, logicalFileDescription.url, logicalFileDescription.md5, logicalFileDescription.size);
        }
        for (String string : this.envs) {
            ps.printf("  envs '%s'\n", string);
        }
        ps.printf("  tag '%s'", this.tag);
    }

    public static enum Status {
        UNSET(-1),
        UNKNOWN(0),
        INIT(1),
        RUNNING(2),
        FINISHED(3),
        ERROR(4),
        TEMPFAILED(5);

        private final int value;

        private Status(int v) {
            this.value = v;
        }

        public int value() {
            return this.value;
        }
    }
}

