/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.g3bridge;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HttpFileService {
    private File path_localprefix;
    private URL url_httpprefix;

    public HttpFileService(File path_localprefix, URL url_httpprefix) throws IOException {
        this(path_localprefix, url_httpprefix, false);
    }

    public HttpFileService(File path_localprefix, URL url_httpprefix, boolean auto_mkdir) throws IOException {
        this.path_localprefix = path_localprefix;
        this.url_httpprefix = url_httpprefix;
        if (auto_mkdir && !this.path_localprefix.exists() && !this.path_localprefix.mkdirs()) {
            throw new IOException("directory " + this.path_localprefix.getPath() + " can't be created.");
        }
        if (!this.path_localprefix.isDirectory()) {
            throw new IOException("directory " + this.path_localprefix.getPath() + " not exists.");
        }
        if (!this.path_localprefix.canWrite()) {
            throw new IOException("directory " + this.path_localprefix.getPath() + " is not writable.");
        }
    }

    public File getPath_localprefix() {
        return this.path_localprefix;
    }

    public URL getUrl_httpprefix() {
        return this.url_httpprefix;
    }

    public Info provideFile(File sourceFile, String relProvidedPath) throws IOException {
        return this.provideFile(sourceFile, relProvidedPath, true);
    }

    public Info provideFile(File sourceFile, String relProvidedPath, boolean computeMd5) throws IOException {
        File target;
        if (!sourceFile.isFile()) {
            throw new IOException("unexcepted path '" + sourceFile.getAbsolutePath() + "': not a path to a file.");
        }
        if (!sourceFile.canRead()) {
            throw new IOException("access rights '" + sourceFile.getAbsolutePath() + "': can read file.");
        }
        Info result = new Info();
        result.localFileName = target = new File(this.path_localprefix, relProvidedPath);
        result.remoteURL = new URL(this.url_httpprefix + "/" + relProvidedPath);
        if (!target.exists()) {
            File parent = target.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("failed to create subdirectories for: " + parent.getAbsolutePath());
            }
            if (!target.createNewFile()) {
                throw new IOException("failed to create file, subdirectories exists. " + target.getAbsolutePath());
            }
        }
        if (!target.canWrite()) {
            throw new IOException("access rights '" + target.getAbsolutePath() + "': can not write target file.");
        }
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        FileInputStream sourceInputStream = new FileInputStream(sourceFile);
        FileChannel sourceChannel = sourceInputStream.getChannel();
        targetChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        if (computeMd5) {
            try {
                long curr_chunksize;
                MessageDigest md5 = MessageDigest.getInstance("MD5");
                sourceInputStream = new FileInputStream(sourceFile);
                sourceChannel = sourceInputStream.getChannel();
                long chunksize = Math.min(sourceChannel.size(), 0x1E00000L);
                for (long position = 0L; position < sourceChannel.size(); position += curr_chunksize) {
                    curr_chunksize = Math.min(sourceChannel.size() - position, chunksize);
                    MappedByteBuffer buffer = sourceChannel.map(FileChannel.MapMode.READ_ONLY, position, curr_chunksize);
                    md5.update(buffer);
                }
                BigInteger bigInt = new BigInteger(1, md5.digest());
                StringBuilder hashtext = new StringBuilder();
                String hash = bigInt.toString(16);
                hashtext.append(hash);
                result.md5hash = hashtext.toString();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public boolean delete(String relProvidedPath) throws IOException {
        String path = this.path_localprefix + "/" + relProvidedPath;
        File file = new File(path);
        if (!file.isFile()) {
            throw new IOException("unexcepted path '" + relProvidedPath + "': not a path to a file.");
        }
        if (!file.canRead()) {
            throw new IOException("access rights '" + relProvidedPath + "': can read file.");
        }
        return file.delete();
    }

    public static class Info {
        public File localFileName = null;
        public URL remoteURL = null;
        public String md5hash = null;
    }
}

