/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs.g3bridge;

import de.fzj.unicore.uas.client.BaseUASClient;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.USEClientProperties;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeException;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeMonitor;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeSubmitter;
import de.pc2.unicore.edgi.xnjs.g3bridge.JobDescription;
import de.pc2.unicore.edgi.xnjs.g3bridge.LogicalFileDescription;
import de.pc2.unicore.edgi.xnjs.g3bridge.MockMonitorImpl;
import de.pc2.unicore.edgi.xnjs.g3bridge.MockSubmitterImpl;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetCPUCountRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetCPUCountResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetRunningJobsRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetRunningJobsResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetWaitingJobsRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeMonitorWsdl.GetWaitingJobsResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.DeleteRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetFinishedRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetFinishedResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridAlgRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridAlgResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridDataRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetGridDataResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetOutputRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetOutputResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetStatusRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GetStatusResponseDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GridAlgList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.GridDataList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.Job;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.JobIDList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.JobList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.JobOutput;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.LogicalFile;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.OutputList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.StatusList;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.SubmitRequestDocument;
import eu.edgesGrid.wsdl.x3GBridgeWsdl.SubmitResponseDocument;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFireRuntimeException;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class G3BridgeClient {
    private static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi.G3BridgeClient", G3BridgeClient.class);
    private final G3BridgeSubmitter submitter;
    private final G3BridgeMonitor monitor;

    public G3BridgeClient(String url_submitter, String url_monitor, Kernel kernel) throws G3BridgeException {
        try {
            USEClientProperties cc = kernel.getClientConfiguration();
            EndpointReferenceType epr1 = EndpointReferenceType.Factory.newInstance();
            epr1.addNewAddress().setStringValue(url_submitter);
            this.submitter = !"mock".equals(url_submitter) ? (G3BridgeSubmitter)new BaseUASClient(epr1, (IClientConfiguration)cc).makeProxy(G3BridgeSubmitter.class) : new MockSubmitterImpl();
            if (url_monitor != null) {
                EndpointReferenceType epr2 = EndpointReferenceType.Factory.newInstance();
                epr2.addNewAddress().setStringValue(url_monitor);
                this.monitor = !"mock".equals(url_monitor) ? (G3BridgeMonitor)new BaseUASClient(epr1, (IClientConfiguration)cc).makeProxy(G3BridgeMonitor.class) : new MockMonitorImpl();
            } else {
                this.monitor = null;
            }
        }
        catch (Exception e) {
            LogUtil.logException((String)"creating SOAP-classes throws exception", (Throwable)e, (Logger)log);
            throw new G3BridgeException("internal error: creating the G3BridgeSubmitter-proxy failed.", e);
        }
    }

    public void submit(List<JobDescription> jobs) throws G3BridgeException {
        if (log.isInfoEnabled()) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bout);
            for (JobDescription jd : jobs) {
                jd.println(ps);
            }
            ps.flush();
            log.info((Object)("3gbridge submit: \n" + bout.toString()));
        }
        SubmitRequestDocument request = SubmitRequestDocument.Factory.newInstance();
        JobList req_joblist = request.addNewSubmitRequest();
        for (JobDescription job : jobs) {
            Job req_job = req_joblist.addNewJob();
            req_job.setAlg(job.alg);
            req_job.setGrid(job.grid);
            req_job.setArgs(job.args);
            String[] outputs = new String[job.outputs.size()];
            for (int i = 0; i < job.outputs.size(); ++i) {
                outputs[i] = job.outputs.get((int)i).logicalName;
            }
            req_job.setOutputsArray(outputs);
            LogicalFile[] reqLF = new LogicalFile[job.inputs.size()];
            for (int i = 0; i < job.inputs.size(); ++i) {
                LogicalFileDescription currLF = job.inputs.get(i);
                reqLF[i] = LogicalFile.Factory.newInstance();
                reqLF[i].setLogicalName(currLF.logicalName);
                reqLF[i].setURL(currLF.url);
                if (currLF.md5 != null) {
                    reqLF[i].setMd5(currLF.md5);
                }
                if (currLF.size < 0L) continue;
                reqLF[i].setSize(new BigDecimal(currLF.size));
            }
            req_job.setInputsArray(reqLF);
            req_job.setTag(job.tag);
            String[] envs_array = new String[job.envs.size()];
            job.envs.toArray(envs_array);
            req_job.setEnvArray(envs_array);
        }
        SubmitResponseDocument response = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        try {
            response = this.submitter.submit(request);
        }
        catch (XFireRuntimeException e) {
            throw new G3BridgeException("error while submitting: ", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANSWER:\n" + response.toString()));
        }
        JobIDList resp_joblistid = response.getSubmitResponse();
        log.info((Object)("3gbridge returned ids = " + Arrays.toString(resp_joblistid.getJobidArray())));
        for (int i = 0; i < jobs.size(); ++i) {
            jobs.get((int)i).id = resp_joblistid.getJobidArray(i);
        }
    }

    public void updateStatus(List<JobDescription> jobs) {
        GetStatusRequestDocument request = GetStatusRequestDocument.Factory.newInstance();
        JobIDList req_jobidlist = request.addNewGetStatusRequest();
        for (JobDescription job : jobs) {
            req_jobidlist.addJobid(job.id);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetStatusResponseDocument response = this.submitter.getStatus(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANSWER:\n" + response.toString()));
        }
        StatusList resp_jobstatuslist = response.getGetStatusResponse();
        for (int i = 0; i < jobs.size(); ++i) {
            jobs.get((int)i).status = JobDescription.Status.valueOf(resp_jobstatuslist.getStatusArray(i).toString());
        }
    }

    public void delete(List<JobDescription> jobs) {
        DeleteRequestDocument request = DeleteRequestDocument.Factory.newInstance();
        JobIDList req_jobidlist = request.addNewDeleteRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("delete ids: ");
        for (JobDescription job : jobs) {
            req_jobidlist.addJobid(job.id);
            sb.append(job.id);
        }
        log.info((Object)sb.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        this.submitter.delete(request);
        log.debug((Object)"SOAP NO ANWSER");
        for (JobDescription job : jobs) {
            job.status = JobDescription.Status.UNKNOWN;
        }
    }

    public void deleteById(List<String> jobids) {
        DeleteRequestDocument request = DeleteRequestDocument.Factory.newInstance();
        JobIDList req_jobidlist = request.addNewDeleteRequest();
        StringBuilder sb = new StringBuilder();
        sb.append("delete ids: ");
        for (String id : jobids) {
            req_jobidlist.addJobid(id);
            sb.append(id);
        }
        log.info((Object)sb.toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        this.submitter.delete(request);
        log.debug((Object)"SOAP NO ANWSER");
    }

    public void deleteById(String[] jobids) {
        this.deleteById(Arrays.asList(jobids));
    }

    public void updateOutput(List<JobDescription> jobs) throws G3BridgeException {
        if (jobs.size() == 0) {
            return;
        }
        GetOutputRequestDocument request = GetOutputRequestDocument.Factory.newInstance();
        JobIDList req_jobidlist = request.addNewGetOutputRequest();
        for (JobDescription job : jobs) {
            req_jobidlist.addJobid(job.id);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetOutputResponseDocument response = this.submitter.getOutput(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANSWER:\n" + response.toString()));
        }
        OutputList resp_outputlist = response.getGetOutputResponse();
        for (int i = 0; i < jobs.size(); ++i) {
            JobDescription curr_job = jobs.get(i);
            JobOutput resp_output = resp_outputlist.getOutputArray(i);
            LogicalFile[] resp_logicalfile = resp_output.getOutputArray();
            if (curr_job.outputs != null && curr_job.outputs.size() != resp_logicalfile.length) {
                throw new G3BridgeException("response error, output of requested jobs '" + curr_job.id + "' unequal to url-list for outputs.");
            }
            curr_job.outputs = new ArrayList<LogicalFileDescription>();
            for (int j = 0; j < resp_logicalfile.length; ++j) {
                LogicalFile curr_lf = resp_logicalfile[j];
                LogicalFileDescription curr_lfd = new LogicalFileDescription(curr_lf.getLogicalName());
                curr_lfd.logicalName = curr_lf.getLogicalName();
                curr_lfd.url = curr_lf.getURL();
                curr_lfd.md5 = curr_lf.getMd5();
                curr_lfd.size = -1L;
                BigDecimal size = curr_lf.getSize();
                if (size != null) {
                    curr_lfd.size = size.longValueExact();
                }
                curr_job.outputs.add(curr_lfd);
            }
        }
    }

    public String[] finishedJobs(String grid) {
        GetFinishedRequestDocument request = GetFinishedRequestDocument.Factory.newInstance();
        request.setGetFinishedRequest(grid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetFinishedResponseDocument response = this.submitter.getFinished(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        JobIDList jobidlist = response.getGetFinishedResponse();
        return jobidlist.getJobidArray();
    }

    public String[] gridData(List<String> grids) {
        GetGridDataRequestDocument request = GetGridDataRequestDocument.Factory.newInstance();
        JobIDList req_jobidlist = request.addNewGetGridDataRequest();
        for (String grid : grids) {
            req_jobidlist.addJobid(grid);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetGridDataResponseDocument response = this.submitter.getGridData(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        GridDataList griddatalist = response.getGetGridDataResponse();
        return griddatalist.getGriddataArray();
    }

    public String[] gridAlg(String grid) {
        GetGridAlgRequestDocument request = GetGridAlgRequestDocument.Factory.newInstance();
        request.setGetGridAlgRequest(grid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetGridAlgResponseDocument response = this.submitter.getGridAlg(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        GridAlgList griddatalist = response.getGetGridAlgResponse();
        return griddatalist.getGridalgsArray();
    }

    public String version_submitter() {
        return this.submitter.version().getGetVersionResponse();
    }

    public boolean has_monitor_interface() {
        return this.monitor != null;
    }

    public String version_monitor() {
        if (this.monitor == null) {
            throw new RuntimeException("monitoring interface is not specified");
        }
        return this.monitor.version().getGetVersionResponse();
    }

    public long cpuCount(String grid) {
        if (this.monitor == null) {
            throw new RuntimeException("monitoring interface is not specified");
        }
        GetCPUCountRequestDocument request = GetCPUCountRequestDocument.Factory.newInstance();
        request.setGetCPUCountRequest(grid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetCPUCountResponseDocument response = this.monitor.getCPUCount(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        return response.getGetCPUCountResponse();
    }

    public long runningJobs(String grid) {
        if (this.monitor == null) {
            throw new RuntimeException("monitoring interface is not specified");
        }
        GetRunningJobsRequestDocument request = GetRunningJobsRequestDocument.Factory.newInstance();
        request.setGetRunningJobsRequest(grid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetRunningJobsResponseDocument response = this.monitor.getRunningJobs(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        return response.getGetRunningJobsResponse();
    }

    public long waitingJobs(String grid) {
        if (this.monitor == null) {
            throw new RuntimeException("monitoring interface is not specified");
        }
        GetWaitingJobsRequestDocument request = GetWaitingJobsRequestDocument.Factory.newInstance();
        request.setGetWaitingJobsRequest(grid);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP REQUEST:\n" + request.toString()));
        }
        GetWaitingJobsResponseDocument response = this.monitor.getWaitingJobs(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("SOAP ANWSER:\n" + response.toString()));
        }
        return response.getGetWaitingJobsResponse();
    }
}

