/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.event.EventHandler;
import de.fzj.unicore.xnjs.ems.event.XnjsEvent;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.pc2.unicore.edgi.xnjs.UtilSubactionManager;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class UtilSubaction {
    protected static final UtilSubactionManager manager = new UtilSubactionManager();
    public String groupid;
    public Action parent;
    public Configuration conf;

    public UtilSubaction(Configuration conf, Action parent, String groupid) {
        this.groupid = groupid;
        this.parent = parent;
        this.conf = conf;
    }

    public boolean hadSubactions() {
        return this.parent.getProcessingContext().get((Object)this.groupid) != null;
    }

    public ArrayList<String> getSubactionUUIDs() {
        ArrayList ret = (ArrayList)this.parent.getProcessingContext().get((Object)this.groupid);
        if (ret == null) {
            ret = new ArrayList();
            this.parent.getProcessingContext().put((Object)this.groupid, ret);
            this.parent.setDirty();
        }
        return ret;
    }

    public boolean pendingSubactions() {
        ArrayList<String> v = this.getSubactionUUIDs();
        assert (v != null);
        return !v.isEmpty();
    }

    public void execSubaction(Runnable r) {
        String uuid = null;
        if (r instanceof IFileTransfer) {
            IFileTransfer ft = (IFileTransfer)r;
            uuid = ft.getUniqueId();
            manager.add_and_execute(uuid, r);
        } else {
            uuid = manager.add_and_execute(r);
        }
        this.getSubactionUUIDs().add(uuid);
        this.parent.addLogTrace("Subaction started: '" + uuid + "'.");
        this.parent.setDirty();
    }

    public ArrayList<Runnable> getSubactions() {
        ArrayList<String> uuids = this.getSubactionUUIDs();
        ArrayList<Runnable> ret = new ArrayList<Runnable>();
        for (String uuid : uuids) {
            ret.add(manager.get(uuid));
        }
        return ret;
    }

    public ArrayList<IFileTransfer> getSubactionsAsIFileTransfer() {
        ArrayList<String> uuids = this.getSubactionUUIDs();
        ArrayList<IFileTransfer> ret = new ArrayList<IFileTransfer>();
        for (String uuid : uuids) {
            Runnable r = manager.get(uuid);
            if (r instanceof IFileTransfer) {
                ret.add((IFileTransfer)r);
                continue;
            }
            this.parent.addLogTrace("data inconsistency, unexpected type not IFileTransfer of Subaction/Action: '" + uuid + "'/'" + this.parent.getUUID() + "'");
            this.parent.setDirty();
        }
        return ret;
    }

    public Runnable abort(String uuid) {
        Runnable ret = manager.abort(uuid);
        if (ret instanceof IFileTransfer) {
            ((IFileTransfer)ret).abort();
        }
        this.getSubactionUUIDs().remove(uuid);
        this.parent.addLogTrace("Subaction abort: '" + uuid + "'.");
        this.parent.setDirty();
        return ret;
    }

    public void wakeup(long delaysec) {
        DelayedEvent r = new DelayedEvent(this.parent.getUUID(), (EventHandler)this.conf.getInternalManager());
        if (delaysec == 0L) {
            r.run();
        } else {
            this.conf.getScheduledExecutor().schedule(r, delaysec, TimeUnit.SECONDS);
        }
    }

    static class DelayedEvent
    implements Runnable {
        protected EventHandler handler;
        protected String actionid;

        public DelayedEvent(String actionid, EventHandler handler) {
            this.handler = handler;
            this.actionid = actionid;
        }

        @Override
        public void run() {
            try {
                this.handler.handleEvent((XnjsEvent)new ContinueProcessingEvent(this.actionid));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

