/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs;

import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughCapabilities;
import de.pc2.unicore.edgi.xnjs.io.passthrough.URIComposed;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.DataStagingType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.SourceTargetType;

public class UtilAction {
    protected static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi", UtilAction.class);
    protected Action a = null;
    protected JobDefinitionType jsdl = null;
    protected DataStagingType[] staging = null;

    public UtilAction(Action a) {
        this.a = a;
    }

    JobDefinitionType getJSDL() {
        if (this.jsdl == null) {
            this.jsdl = ((JobDefinitionDocument)this.a.getAjd()).getJobDefinition();
        }
        return this.jsdl;
    }

    DataStagingType[] getStaging() {
        if (this.staging == null) {
            this.staging = this.getJSDL().getJobDescription().getDataStagingArray();
        }
        return this.staging;
    }

    public ArrayList<StagingEntry> getStagingEntries(boolean forStagin) {
        StagingEntry x;
        this.getStaging();
        if (this.staging == null) {
            return null;
        }
        ArrayList<StagingEntry> ret = new ArrayList<StagingEntry>();
        String files = "";
        ExecutionContext ec = this.a.getExecutionContext();
        if (ec != null) {
            HashMap hashMap = ec.getEnvironment();
            if (!forStagin) {
                files = (String)hashMap.get("OUTPUT");
            }
            if (files == null) {
                files = "";
            }
        }
        for (DataStagingType dataStagingType : this.getStaging()) {
            x = StagingEntry.fromDS(dataStagingType);
            if (x.stagein != forStagin) continue;
            ret.add(x);
            files = files.replaceFirst(x.filename, "").trim();
        }
        if (files.length() > 0) {
            for (String string : files.split(" ")) {
                x = new StagingEntry(null, string, string, true);
                ret.add(x);
            }
        }
        return ret;
    }

    public ArrayList<StagingEntry> getStagingInEntries_dgconverted(String httpLocalPrefix, String httpRemotePrefix) throws ExecutionException {
        ArrayList<StagingEntry> ret = this.getStagingEntries(true);
        HashMap<StagingEntry, String> err = new HashMap<StagingEntry, String>();
        String ucjobwd = this.a.getExecutionContext().getWorkingDirectory();
        File ucjobwd_file = new File(ucjobwd);
        String dgjobwd = ucjobwd.replace(httpLocalPrefix, httpRemotePrefix);
        assert (!ucjobwd.equals(dgjobwd)) : "data inconsistency, local and remote file path is equal but shouldn't.";
        ArrayList<String> already_stagedin_files = new ArrayList<String>(Arrays.asList(ucjobwd_file.list()));
        for (StagingEntry e : ret) {
            if (e.filename == null) {
                err.put(e, "internal error, no logical filename.");
                continue;
            }
            if (already_stagedin_files.contains(e.filename)) {
                already_stagedin_files.remove(e.filename);
            }
            e.file = new File(ucjobwd, e.filename);
            e.uri = dgjobwd + e.filename;
            if (e.uri_org == null || !PassthroughCapabilities.isValidUri(e.uri_org) || e.file.exists()) continue;
            e.file = null;
            try {
                URIComposed uric;
                e.uric = uric = URIComposed.fromOuterURI(new URI(e.uri_org));
                e.uri = uric.toComposed();
            }
            catch (NumberFormatException e1) {
                err.put(e, "internal error: " + e1.toString());
            }
            catch (URISyntaxException e1) {
                err.put(e, "internal error: " + e1.toString());
            }
        }
        for (String fn : already_stagedin_files) {
            StagingEntry e = new StagingEntry(dgjobwd + fn, fn, fn, true);
            e.file = new File(ucjobwd, e.filename);
            ret.add(e);
        }
        if (err.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : err.entrySet()) {
                sb.append((String)entry.getValue() + "\n   ");
                sb.append(((StagingEntry)entry.getKey()).toString());
            }
            throw new ExecutionException(sb.toString());
        }
        return ret;
    }

    public static class StagingEntry {
        public String uri;
        public URIComposed uric;
        public String uri_org;
        public String filename;
        public File file;
        public String name;
        public boolean stagein;

        public StagingEntry(String uri, String name, String filename, boolean stagein) {
            this.uri = this.uri_org = uri;
            this.uric = null;
            this.name = name;
            this.filename = filename;
            this.stagein = stagein;
        }

        public String toString() {
            return "URI_ORG=" + this.uri_org + ", URI=" + this.uri + ", URIC=" + this.uric.toString() + ", LN=" + this.filename + ", LFN=" + this.name + ", PATH=" + this.file.toString() + ", NAME=" + this.name;
        }

        public static StagingEntry fromDS(DataStagingType stage) {
            boolean stagein;
            String name = stage.getName();
            SourceTargetType x = stage.getSource();
            boolean bl = stagein = x != null;
            if (x == null) {
                x = stage.getTarget();
            }
            assert (x != null);
            String filename = stage.getFileName();
            String uri = x.getURI();
            return new StagingEntry(uri, name, filename, stagein);
        }
    }
}

