/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.monitoring.ReportException;
import de.pc2.unicore.edgi.monitoring.XMLLogReport;
import de.pc2.unicore.edgi.xnjs.UtilConfigWrapper;
import java.net.URL;
import org.apache.log4j.Logger;

public class MonitoringHelperThread
implements Runnable {
    protected static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi", MonitoringHelperThread.class);
    private XMLLogReport report;
    private boolean isRunning;

    public MonitoringHelperThread(XMLLogReport report) {
        this.report = report;
        this.isRunning = true;
    }

    @Override
    public void run() {
        if (this.isRunning) {
            try {
                Thread.sleep(this.report.getReportingInterval() * 1000L);
            }
            catch (InterruptedException e) {
                LogUtil.logException((String)"ignored exception ", (Throwable)e, (Logger)log);
            }
            try {
                this.report.output();
            }
            catch (ReportException e) {
                LogUtil.logException((String)"ignored exception while writing monitoring event", (Throwable)e, (Logger)log);
            }
            try {
                this.report.cleanup();
            }
            catch (ReportException e) {
                LogUtil.logException((String)"while cleaningup old files", (Throwable)e, (Logger)log);
            }
        }
    }

    public void stopit() {
        this.isRunning = false;
    }

    public XMLLogReport getReport() {
        return this.report;
    }

    public static MonitoringHelperThread createFromConfiguration(Configuration conf, XMLLogReport lr) throws ExecutionException {
        if (lr.isdisabled()) {
            return null;
        }
        return new MonitoringHelperThread(lr);
    }

    public static XMLLogReport createLogReportFromConfiguration(Configuration conf) throws ExecutionException, ReportException {
        UtilConfigWrapper helper = new UtilConfigWrapper(conf, log);
        String reportsPath = helper.getProperty("MONITOR.directory", null);
        long reportingInterval = helper.getPropertyInt("MONITOR.interval_save", 600);
        long cleanupAgeHour = helper.getPropertyInt("MONITOR.interval_cleanup", 168);
        URL test_remote = helper.getPropertyURL("MONITOR.test_remote", null, true);
        XMLLogReport lr = new XMLLogReport(reportingInterval, cleanupAgeHour, reportsPath);
        log.info((Object)lr.statusMessage(test_remote == null ? null : test_remote.toString()));
        return lr;
    }
}

