/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs;

import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.Action;
import de.fzj.unicore.xnjs.ems.ExecutionContext;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.ems.InternalManager;
import de.fzj.unicore.xnjs.ems.Manager;
import de.fzj.unicore.xnjs.ems.event.ContinueProcessingEvent;
import de.fzj.unicore.xnjs.ems.event.XnjsEvent;
import de.fzj.unicore.xnjs.io.XnjsFileWithACL;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.fzj.unicore.xnjs.tsi.ApplicationInfo;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.idb.ApplicationRepository;
import de.pc2.unicore.edgi.idb.ApplicationRepositoryException;
import de.pc2.unicore.edgi.monitoring.ReportException;
import de.pc2.unicore.edgi.monitoring.XMLLogReport;
import de.pc2.unicore.edgi.xnjs.DesktopGridJobProcessor;
import de.pc2.unicore.edgi.xnjs.DesktopGridTSI;
import de.pc2.unicore.edgi.xnjs.MonitoringHelperThread;
import de.pc2.unicore.edgi.xnjs.UtilAction;
import de.pc2.unicore.edgi.xnjs.UtilConfigWrapper;
import de.pc2.unicore.edgi.xnjs.XnjsFileDB;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeClient;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeException;
import de.pc2.unicore.edgi.xnjs.g3bridge.JobDescription;
import de.pc2.unicore.edgi.xnjs.g3bridge.LogicalFileDescription;
import de.pc2.unicore.edgi.xnjs.io.passthrough.PassthroughCapabilities;
import eu.unicore.security.Client;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Lifecycle(isSingleton=true)
@Dependency(classes={ApplicationRepository.class})
public class DesktopGridManager {
    private static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi", DesktopGridManager.class);
    private final Configuration configuration;
    private final G3BridgeClient g3bridge;
    private final Map<String, JobDescription> dgInfo = new HashMap<String, JobDescription>();
    protected String desktop_grid_queue_name = "Null";
    protected String local_filespace = null;
    protected String remote_filespace = null;
    protected long interval_check_subactions_sec = 5L;
    private XMLLogReport monitoring;
    private MonitoringHelperThread monitoringThread;
    protected String optionStdout = null;
    protected String optionStderr = null;
    protected boolean optionUserDN = false;
    private final ApplicationRepository appAR;

    public DesktopGridManager(Configuration conf) throws G3BridgeException, ExecutionException, MalformedURLException {
        this.configuration = conf;
        UtilConfigWrapper helper = new UtilConfigWrapper(conf, log);
        this.desktop_grid_queue_name = helper.getProperty("DGTSI.desktop_grid_queue_name", this.desktop_grid_queue_name);
        this.local_filespace = helper.getProperty("XNJS.filespace", null);
        this.remote_filespace = helper.getProperty("DGTSI.remote", null);
        this.optionStdout = helper.getProperty("DGTSI.stdout", "");
        this.optionStderr = helper.getProperty("DGTSI.stderr", "");
        this.optionUserDN = helper.getPropertyBool("DGTSI.allow_proxy_userdn", false);
        if (this.optionStdout != null && this.optionStdout.length() == 0) {
            this.optionStdout = null;
        }
        if (this.optionStderr != null && this.optionStderr.length() == 0) {
            this.optionStderr = null;
        }
        PassthroughCapabilities.register(conf);
        Kernel kernel = (Kernel)conf.getComponentInstanceOfType(Kernel.class);
        this.g3bridge = this.setupClient(helper, kernel);
        this.setupMonitoring();
        this.appAR = (ApplicationRepository)this.configuration.getComponentInstanceOfType(ApplicationRepository.class);
        int interval_dgpolling = helper.getPropertyInt("DGTSI.interval_dgpolling", 300);
        Updater x = new Updater(this);
        this.configuration.getScheduledExecutor().scheduleWithFixedDelay(x, interval_dgpolling, interval_dgpolling, TimeUnit.SECONDS);
        log.info((Object)("Will update job states every <" + interval_dgpolling + "> seconds."));
    }

    private void setupMonitoring() throws ExecutionException {
        try {
            this.monitoring = MonitoringHelperThread.createLogReportFromConfiguration(this.configuration);
            this.monitoringThread = MonitoringHelperThread.createFromConfiguration(this.configuration, this.monitoring);
            if (this.monitoringThread != null) {
                long interval = this.monitoringThread.getReport().getReportingInterval();
                this.configuration.getScheduledExecutor().scheduleWithFixedDelay(this.monitoringThread, interval, interval, TimeUnit.SECONDS);
            }
        }
        catch (ReportException e) {
            log.fatal((Object)"error during monitoring system init: ", (Throwable)e);
        }
    }

    private G3BridgeClient setupClient(UtilConfigWrapper helper, Kernel kernel) throws G3BridgeException, ExecutionException {
        String version;
        String url_monitor = helper.getProperty("DGTSI.url_3gbridge_monitor", "");
        String version_monitor = helper.getProperty("DGTSI.versioncheck_3gbridge_monitor", "");
        String url_submitter = helper.getProperty("DGTSI.url_3gbridge_submitter", null);
        String version_submitter = helper.getProperty("DGTSI.versioncheck_3gbridge_submitter", "");
        G3BridgeClient client = new G3BridgeClient(url_submitter, url_monitor, kernel);
        if (version_submitter.length() > 0 && !(version = client.version_submitter()).contains(version_submitter)) {
            throw new G3BridgeException("Version of 3gbridge mismatched,\n  requirement: '" + version_submitter + "'  (see xnjs.conf)" + "\n  url = '" + url_submitter.toString() + "', version = '" + version + "'");
        }
        if (url_monitor != null && version_monitor.length() > 0 && !(version = client.version_monitor()).contains(version_monitor)) {
            throw new G3BridgeException("Version of 3gbridge mismatched,\n  requirement: '" + version_monitor + "'  (see xnjs.conf)" + "\n  url = '" + url_monitor.toString() + "', version = '" + version + "'");
        }
        return client;
    }

    public void submit(ApplicationInfo appDescription, Action ucjob) throws ExecutionException, G3BridgeException {
        Client client = ucjob.getClient();
        DesktopGridTSI tsi = (DesktopGridTSI)this.configuration.getTargetSystemInterface(client);
        ExecutionContext ec = ucjob.getExecutionContext();
        HashMap envs = ec.getEnvironment();
        ApplicationRepository.Impl dg_impl = null;
        ApplicationRepository.App dg_app = null;
        String shortcut = appDescription.getExecutable();
        try {
            dg_impl = this.appAR.getImplByShortcut(shortcut);
            dg_app = this.appAR.getAppByShortcut(shortcut);
            if (log.isDebugEnabled()) {
                log.debug((Object)("for shortcut '" + shortcut + "': \n" + this.appAR.debugString(dg_impl, dg_app)));
            }
        }
        catch (ApplicationRepositoryException are) {
            throw new ExecutionException("Application '" + shortcut + "' could not be mapped to an desktop-grid application-repository entry.", (Throwable)are);
        }
        catch (Exception are) {
            throw new ExecutionException("Fatal: Application '" + shortcut + "' mapping to DG application-repository entry failed.", (Throwable)are);
        }
        if (ec.isInteractive()) {
            throw new ExecutionException("this TSI/the system can't handle interactive jobs on Desktop Grids.");
        }
        StringBuffer args = new StringBuffer();
        for (String s : appDescription.getArguments()) {
            args.append(s);
            args.append(" ");
        }
        if (envs.containsKey("ARGUMENTS")) {
            args.append((String)envs.get("ARGUMENTS"));
        }
        UtilAction ucjobutil = new UtilAction(ucjob);
        ArrayList<UtilAction.StagingEntry> stage_entries = ucjobutil.getStagingInEntries_dgconverted(this.local_filespace, this.remote_filespace);
        ArrayList<LogicalFileDescription> inputs = new ArrayList<LogicalFileDescription>();
        ArrayList<String> outputs = new ArrayList<String>();
        if (stage_entries != null) {
            for (UtilAction.StagingEntry e : stage_entries) {
                LogicalFileDescription ldf = null;
                if (e.uric != null) {
                    ldf = new LogicalFileDescription(e.filename, e.uric.uri.toString(), e.uric.md5, e.uric.size);
                } else {
                    XnjsFileWithACL xf = tsi.getProperties(e.file.getAbsolutePath());
                    assert (xf != null);
                    String md5 = "";
                    try {
                        md5 = XnjsFileDB.computeMD5(e.file.getAbsolutePath());
                    }
                    catch (NoSuchAlgorithmException e1) {
                        log.error((Object)"failed to compute info about local file (e.g. md5)", (Throwable)e1);
                    }
                    catch (IOException e1) {
                        log.error((Object)"failed to compute info about local file (e.g. md5)", (Throwable)e1);
                    }
                    ldf = new LogicalFileDescription(e.filename, e.uri, md5, xf.getSize());
                }
                inputs.add(ldf);
            }
        }
        if ((stage_entries = ucjobutil.getStagingEntries(false)) != null) {
            for (UtilAction.StagingEntry e : stage_entries) {
                outputs.add(e.filename);
            }
        }
        if (this.optionStdout != null) {
            ec.setStdout(this.optionStdout);
            outputs.add(this.optionStdout);
        }
        if (this.optionStderr != null) {
            ec.setStderr(this.optionStderr);
            outputs.add(this.optionStderr);
        }
        ArrayList<String> dgenvs = new ArrayList<String>();
        if (this.optionUserDN) {
            dgenvs.add("PROXY_USERDN=" + ucjob.getClient().getDistinguishedName());
        } else {
            dgenvs.add("PROXY_USERDN=local_disabled_feature");
        }
        String tags = "";
        ArrayList<JobDescription> dgjobs = new ArrayList<JobDescription>();
        dgjobs.add(new JobDescription(dg_app.name, this.desktop_grid_queue_name, args.toString(), inputs, outputs, dgenvs, tags));
        ucjob.addLogTrace("submitting job.");
        this.g3bridge.submit(dgjobs);
        if (((JobDescription)dgjobs.get((int)0)).id == null) {
            ucjob.addLogTrace("submitting failed, see logs of U/X site.");
        }
        ucjob.setBSID(((JobDescription)dgjobs.get((int)0)).id);
        ucjob.addLogTrace("job submitted, desktop-grid-ID (3gBridgeID) = '" + ucjob.getBSID() + "'");
        log.debug((Object)("DEBUG current status " + ucjob.getStatusAsString()));
        StringBuffer input_grid_info = new StringBuffer();
        input_grid_info.append("UNICORE/");
        if (client.getXlogin().getGroup() != null) {
            input_grid_info.append(client.getXlogin().getGroup());
        }
        this.monitoring.jobEntry(ucjob.getUUID(), ((JobDescription)dgjobs.get((int)0)).alg, input_grid_info.toString());
        this.monitoring.jobSubmission(ucjob.getUUID(), ucjob.getStatusAsString(), this.appAR.getDgId(), ucjob.getBSID());
        ucjob.getProcessingContext().put(JobDescription.class, dgjobs.get(0));
    }

    private JobDescription getJobDescriptionFromAction(Action ucjob) {
        if (ucjob.getBSID() == null) {
            return null;
        }
        JobDescription dgjd = (JobDescription)ucjob.getProcessingContext().get(JobDescription.class);
        if (dgjd == null) {
            ArrayList<JobDescription> dgjobs = new ArrayList<JobDescription>();
            dgjobs.add(new JobDescription(ucjob.getBSID()));
            this.g3bridge.updateStatus(dgjobs);
            dgjd = (JobDescription)dgjobs.get(0);
            ucjob.getProcessingContext().put(JobDescription.class, (Object)dgjd);
        }
        return dgjd;
    }

    public void post_monitor_change_status(Action ucjob, String alg) {
        String statusstr = ucjob.getStatusAsString();
        if (statusstr.equals("DONE") || statusstr.equals("POSTPROCESSING")) {
            statusstr = "FINISHED";
        }
        this.monitoring.jobChangeStatus(ucjob.getUUID(), alg, statusstr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatus(Action ucjob, JobDescription.Status newstatus) throws G3BridgeException {
        JobDescription dgjd = null;
        Map<String, JobDescription> map = this.dgInfo;
        synchronized (map) {
            dgjd = this.dgInfo.get(ucjob.getUUID());
        }
        if (dgjd == null) {
            return;
        }
        ucjob.getProcessingContext().put(JobDescription.class, (Object)dgjd);
        JobDescription.Status dgstatus = dgjd.status;
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateStatus (evoke trigger on change) for '" + ucjob.getStatusAsString() + "' / (dg:)'" + (Object)((Object)dgstatus) + "'  " + DesktopGridManager.logmsgprefix(ucjob)));
        }
        if (dgstatus == JobDescription.Status.UNSET) {
            ucjob.setStatus(5);
            this.post_monitor_change_status(ucjob, dgjd.alg);
        } else if (dgstatus == JobDescription.Status.UNKNOWN) {
            if (ucjob.getStatus() == 5) {
                ucjob.addLogTrace("lost desktop grid job (UNKNOWN) => fail");
                ucjob.fail("lost desktop grid job.");
                this.post_monitor_change_status(ucjob, dgjd.alg);
            } else {
                log.warn((Object)("unkown dgjob-status, ucjob-status '" + ucjob.getStatus() + "' " + DesktopGridManager.logmsgprefix(ucjob)));
            }
        } else if (dgstatus == JobDescription.Status.INIT) {
            if (ucjob.getStatus() != 5) {
                ucjob.addLogTrace("new desktop grid / 3gbridge status = INIT  => uc: RUNNING");
                ucjob.setStatus(5);
                this.post_monitor_change_status(ucjob, dgjd.alg);
            }
        } else if (dgstatus == JobDescription.Status.RUNNING) {
            if (ucjob.getStatus() != 5) {
                ucjob.addLogTrace("new desktop grid / 3gbridge status = RUNNING  => uc: RUNNING");
                ucjob.setStatus(5);
                this.post_monitor_change_status(ucjob, dgjd.alg);
            }
        } else if (dgstatus == JobDescription.Status.FINISHED) {
            ucjob.getProcessingContext().put((Object)DesktopGridJobProcessor.STAGEOUT_CONTROL, (Object)"INIT");
        } else if (dgstatus == JobDescription.Status.ERROR) {
            ArrayList<JobDescription> dgjobs = new ArrayList<JobDescription>();
            dgjobs.add(dgjd);
            this.g3bridge.updateOutput(dgjobs);
            log.error((Object)("3gbridge report ERROR state for this job  " + DesktopGridManager.logmsgprefix(ucjob)));
            ucjob.addLogTrace("desktop grid/3g bridge report ERROR state for this job = fail; try to download stageout files.");
            ucjob.getProcessingContext().put((Object)DesktopGridJobProcessor.STAGEOUT_CONTROL, (Object)"INIT");
            ucjob.getProcessingContext().put((Object)DesktopGridJobProcessor.FAIL_AFTER_STAGEOUT, (Object)Boolean.TRUE);
            ArrayList<JobDescription> dgjobs2 = new ArrayList<JobDescription>();
            dgjobs2.add(dgjd);
            this.g3bridge.delete(dgjobs2);
            log.debug((Object)("updatestatus (ERROR): forget about " + DesktopGridManager.logmsgprefix(ucjob)));
        } else if (dgstatus == JobDescription.Status.TEMPFAILED) {
            log.warn((Object)("3gbridge report TEMPFAILED state for this job.  " + DesktopGridManager.logmsgprefix(ucjob)));
            ucjob.addLogTrace("report TEMPFAILED state for this job => waiting for selfhealing");
        }
    }

    public void delete(Action ucjob) throws G3BridgeException {
        JobDescription dgjd = this.getJobDescriptionFromAction(ucjob);
        if (dgjd == null || dgjd.status == JobDescription.Status.UNKNOWN) {
            return;
        }
        this.deleteOnDG(dgjd);
        ucjob.fail("job is delete due to user command.");
        log.debug((Object)("delete: remove entry at desktop grid / 3gbridge " + DesktopGridManager.logmsgprefix(ucjob)));
    }

    public void deleteOnDG(JobDescription dgjd) throws G3BridgeException {
        ArrayList<JobDescription> dgjobs = new ArrayList<JobDescription>();
        dgjobs.add(dgjd);
        this.g3bridge.delete(dgjobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JobDescription.Status> updateStatuses() throws G3BridgeException, ExecutionException {
        Manager mgr = this.configuration.getEMSManager();
        InternalManager internal = this.configuration.getInternalManager();
        String[] jobIDs = mgr.list(null);
        HashMap<String, JobDescription.Status> statuschanges = new HashMap<String, JobDescription.Status>();
        if (jobIDs.length == 0) {
            return statuschanges;
        }
        ArrayList<JobDescription> dgjobs = new ArrayList<JobDescription>();
        ArrayList<JobDescription.Status> oldstatuses = new ArrayList<JobDescription.Status>();
        StringBuilder sb = new StringBuilder();
        for (String ucid : jobIDs) {
            Action job = internal.getAction(ucid);
            JobDescription x = this.getJobDescriptionFromAction(job);
            dgjobs.add(x);
            oldstatuses.add(x.status);
            sb.append("\n      ucid='" + ucid + "', dgid='" + x.id + "' ( dgstatus=" + (Object)((Object)x.status) + ")");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("updateStatuses: periodic check of desktop grid / 3gbridge entries: " + sb.toString()));
        }
        this.g3bridge.updateStatus(dgjobs);
        ArrayList<JobDescription> dgjob_finished = new ArrayList<JobDescription>();
        for (int i = 0; i < dgjobs.size(); ++i) {
            String ucid;
            JobDescription dgjob = (JobDescription)dgjobs.get(i);
            ucid = jobIDs[i];
            JobDescription.Status oldstatus = (JobDescription.Status)((Object)oldstatuses.get(i));
            if (dgjob.status == JobDescription.Status.UNKNOWN && (oldstatus == JobDescription.Status.UNKNOWN || oldstatus == JobDescription.Status.UNSET) || oldstatus == dgjob.status) continue;
            statuschanges.put(ucid, dgjob.status);
            log.info((Object)("updateStatuses: status changed " + (Object)((Object)oldstatus) + "' -> '" + (Object)((Object)dgjob.status) + "' " + DesktopGridManager.logmsgprefix(ucid, dgjob.id) + " (dg:)'"));
            if (dgjob.status != JobDescription.Status.FINISHED) continue;
            dgjob_finished.add(dgjob);
        }
        this.g3bridge.updateOutput(dgjob_finished);
        Map<String, JobDescription> map = this.dgInfo;
        synchronized (map) {
            this.dgInfo.clear();
            for (int i = 0; i < dgjobs.size(); ++i) {
                JobDescription dgjob = (JobDescription)dgjobs.get(i);
                String ucid = jobIDs[i];
                this.dgInfo.put(ucid, dgjob);
            }
        }
        return statuschanges;
    }

    public static String logmsgprefix(Action ucjob) {
        return DesktopGridManager.logmsgprefix(ucjob.getUUID(), ucjob.getBSID());
    }

    public static String logmsgprefix(String ucid, String dgid) {
        return "[ucid='" + ucid + "'/dgid='" + dgid + "']: ";
    }

    public static class Updater
    implements Runnable {
        private final DesktopGridManager dgm;
        private final InternalManager eh;

        public Updater(DesktopGridManager dgm) {
            this.dgm = dgm;
            this.eh = dgm.configuration.getInternalManager();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Map<String, JobDescription.Status> ucids_dgstatus = this.dgm.updateStatuses();
                for (Map.Entry<String, JobDescription.Status> id_status : ucids_dgstatus.entrySet()) {
                    log.debug((Object)("DesktopGridManager.Updater: desktop grid / 3gbridge status change detected ucid: " + id_status.getKey()));
                    this.eh.handleEvent((XnjsEvent)new ContinueProcessingEvent(id_status.getKey()));
                }
            }
            catch (Throwable e) {
                log.warn((Object)"DesktopGridManager.Updater: Problem updating DG job states", e);
            }
        }
    }
}

