/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.xnjs;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ProcessingException;
import de.fzj.unicore.xnjs.io.IFileTransfer;
import de.fzj.unicore.xnjs.io.IFileTransferEngine;
import de.fzj.unicore.xnjs.jsdl.JSDLProcessor;
import de.fzj.unicore.xnjs.management.Dependency;
import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.xnjs.DesktopGridManager;
import de.pc2.unicore.edgi.xnjs.UtilSubaction;
import de.pc2.unicore.edgi.xnjs.g3bridge.G3BridgeException;
import de.pc2.unicore.edgi.xnjs.g3bridge.JobDescription;
import de.pc2.unicore.edgi.xnjs.g3bridge.LogicalFileDescription;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

@Dependency(classes={DesktopGridManager.class})
public class DesktopGridJobProcessor
extends JSDLProcessor {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services.jobexecution", DesktopGridJobProcessor.class);
    public static final String STAGEOUT_CONTROL = DesktopGridJobProcessor.class.getName() + "_stageout";
    public static final String STAGEOUT_INIT = "INIT";
    public static final String STAGEOUT_RUNNING = "RUNNING";
    public static final String STAGEOUT_DONE = "DONE";
    public static final String FAIL_AFTER_STAGEOUT = DesktopGridJobProcessor.class.getName() + "_FAIL_after_stageout";

    public DesktopGridJobProcessor(Configuration config) {
        super(config);
    }

    protected void handleQueued() throws ProcessingException {
        System.out.println("*** QUEUED " + this.action.getUUID());
        super.handleQueued();
    }

    protected void handleRunning() throws ProcessingException {
        System.out.println("*** RUNNING " + this.action.getUUID());
        super.handleRunning();
        String stageout = (String)this.action.getProcessingContext().get((Object)STAGEOUT_CONTROL);
        if (STAGEOUT_INIT.equals(stageout)) {
            this.action.setWaiting(false);
            this.startStageoutFromDG();
        } else if (STAGEOUT_RUNNING.equals(stageout)) {
            try {
                this.checkStageoutsFromDG();
            }
            catch (G3BridgeException e) {
                throw new ProcessingException("Error handling stage-outs from desktop grid", (Throwable)e);
            }
        }
    }

    private void dgFinished() {
        this.action.addLogTrace("Desktop grid execution FINISHED");
        this.action.setStatus(6);
        this.action.getProcessingContext().put((Object)STAGEOUT_CONTROL, (Object)STAGEOUT_DONE);
    }

    private void startStageoutFromDG() {
        JobDescription dgjd = this.getDGJobDescription();
        if (dgjd.outputs == null || dgjd.outputs.size() == 0) {
            this.dgFinished();
            DesktopGridManager dg = (DesktopGridManager)this.configuration.getComponentInstanceOfType(DesktopGridManager.class);
            dg.post_monitor_change_status(this.action, dgjd.alg);
        } else {
            UtilSubaction ucjobUtil = new UtilSubaction(this.configuration, this.action, "DGStageOut");
            IFileTransferEngine fte = this.configuration.getFileTransferEngine();
            IFileTransfer.OverwritePolicy overwrite = IFileTransfer.OverwritePolicy.OVERWRITE;
            String ucwd = this.action.getExecutionContext().getWorkingDirectory();
            for (LogicalFileDescription lfd : dgjd.outputs) {
                URI source = null;
                try {
                    source = new URI(lfd.url);
                }
                catch (URISyntaxException e) {
                    this.action.addLogTrace("exception while converting 3gbridge-value to uri: '" + lfd.url + "': " + e.toString());
                    continue;
                }
                if (source == null) continue;
                IFileTransfer tf = null;
                try {
                    tf = fte.createFileImport(this.action.getClient(), ucwd, source, lfd.logicalName, overwrite, null);
                }
                catch (IOException e) {
                    this.action.addLogTrace("exception while creating filetransfer '" + source + "'->'" + ucwd + "' '" + lfd.logicalName + "': " + e.toString());
                }
                if (tf == null) continue;
                ucjobUtil.execSubaction((Runnable)tf);
                logger.debug((Object)("uc:" + this.action.getUUID() + ": execute filetransfer '" + tf.getSource() + "' -> '" + tf.getTarget() + "': '" + tf.getUniqueId() + "'"));
                this.action.addLogTrace("execute filetransfer '" + tf.getSource() + "' -> '" + tf.getTarget() + "': '" + tf.getUniqueId() + "'");
            }
        }
    }

    private void checkStageoutsFromDG() throws G3BridgeException {
        UtilSubaction ucjobUtil = new UtilSubaction(this.configuration, this.action, "DGStageOut");
        if (!ucjobUtil.hadSubactions()) {
            this.dgFinished();
        } else {
            ArrayList<IFileTransfer> fts = ucjobUtil.getSubactionsAsIFileTransfer();
            for (IFileTransfer ft : fts) {
                if (ft.getStatus() == IFileTransfer.Status.ABORTED) {
                    this.action.addLogTrace("file transfer aborted : '" + ft.getUniqueId() + "'");
                    logger.debug((Object)("file transfer aborted : '" + ft.getUniqueId() + "'"));
                    ucjobUtil.abort(ft.getUniqueId());
                    continue;
                }
                if (ft.getStatus() == IFileTransfer.Status.FAILED) {
                    this.action.addLogTrace("file transfer failed : '" + ft.getUniqueId() + "'");
                    logger.debug((Object)("file tranfer failed : '" + ft.getUniqueId() + "'"));
                    ucjobUtil.abort(ft.getUniqueId());
                    continue;
                }
                if (ft.getStatus() == IFileTransfer.Status.DONE) {
                    this.action.addLogTrace("file transfer done : '" + ft.getUniqueId() + "'");
                    logger.debug((Object)("file transfer done : '" + ft.getUniqueId() + "'"));
                    ucjobUtil.abort(ft.getUniqueId());
                    continue;
                }
                logger.debug((Object)("file transfer ongoing." + ft.getUniqueId()));
            }
            if (!ucjobUtil.pendingSubactions()) {
                this.dgFinished();
                if (this.action.getProcessingContext().get((Object)FAIL_AFTER_STAGEOUT) != null) {
                    this.deleteDGJob();
                }
            }
        }
    }

    private JobDescription getDGJobDescription() {
        return (JobDescription)this.action.getProcessingContext().get(JobDescription.class);
    }

    private void deleteDGJob() throws G3BridgeException {
        JobDescription dgjd = this.getDGJobDescription();
        DesktopGridManager dg = (DesktopGridManager)this.configuration.getComponentInstanceOfType(DesktopGridManager.class);
        dg.post_monitor_change_status(this.action, dgjd.alg);
        dg.deleteOnDG(dgjd);
    }
}

