/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.monitoring;

import de.fzj.unicore.xnjs.util.LogUtil;
import de.pc2.unicore.edgi.monitoring.ReportEntry;
import de.pc2.unicore.edgi.monitoring.ReportException;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class XMLLogReport {
    static final Logger log = LogUtil.getLogger((String)"unicore.xnjs.tsi", XMLLogReport.class);
    public static final String version = "2.1";
    public static final String PATH_DISABLE = "disable";
    private long reportingInterval = 600L;
    private long cleanupAgeHour = 168L;
    private String reportsPath = null;
    private Vector<ReportEntry> list = new Vector();

    public XMLLogReport() throws ReportException {
        this(600L, 168L, "");
    }

    public XMLLogReport(long reportingInterval, long cleanupAgeHour, String reportsPath) throws ReportException {
        this.reportingInterval = reportingInterval;
        this.setReportsPath(reportsPath);
    }

    public String statusMessage(String remote_url) {
        StringBuilder sb = new StringBuilder();
        sb.append("MONITORING XMLLogReport: ");
        sb.append(!this.isdisabled());
        sb.append("\n");
        sb.append("     interval_save=");
        sb.append(this.reportingInterval);
        sb.append("sec, interval_cleanup=");
        sb.append(this.cleanupAgeHour);
        sb.append("hours");
        sb.append("\n     local path=");
        sb.append(this.reportsPath);
        sb.append("\n     remote url=");
        sb.append(remote_url == null ? "<not configured>" : remote_url);
        sb.append("\n     (This message can be send to EDGI Monitoring System admins to add this site.)");
        return sb.toString();
    }

    public boolean isdisabled() {
        return this.reportsPath.equals(PATH_DISABLE);
    }

    public void setCleanupAge(long hour) throws ReportException {
        if (hour < 0L) {
            throw new ReportException("invalid argument, has to be positive.");
        }
        this.cleanupAgeHour = hour;
    }

    public long getCleanupAge() {
        return this.cleanupAgeHour;
    }

    public void setReportingInterval(long sec) throws ReportException {
        if (sec < 0L) {
            throw new ReportException("invalid argument, has to be positive.");
        }
        this.reportingInterval = sec;
    }

    public long getReportingInterval() {
        return this.reportingInterval;
    }

    public void setReportsPath(String reportsPath) throws ReportException {
        if (reportsPath.equals(PATH_DISABLE)) {
            this.reportsPath = reportsPath;
        } else {
            try {
                this.reportsPath = this.relativPath(reportsPath).getAbsolutePath();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (!this.lazyCreateDir(this.reportsPath)) {
                throw new ReportException("error while creating directory: '" + this.reportsPath + "'");
            }
        }
    }

    public void setReportsPath(File reportsPath) throws ReportException {
    }

    public String getReportsPath() {
        return this.reportsPath;
    }

    private void addEvent(ReportEntry logentry) {
        if (this.isdisabled()) {
            return;
        }
        this.list.addElement(logentry);
        if (log.isDebugEnabled()) {
            log.debug((Object)logentry.toDebugString());
        }
    }

    public void jobSubmission(String job_id, String status, String output_grid, String output_job_id) {
        ReportEntry log = ReportEntry.create("job_submission", job_id);
        log.status = status;
        log.output_grid_name = output_grid;
        log.output_job_id = output_job_id;
        this.addEvent(log);
    }

    public void jobEntry(String job_id, String application, String input_grid) {
        ReportEntry log = ReportEntry.create("job_entry", job_id);
        log.application = application;
        log.input_grid_name = input_grid;
        this.addEvent(log);
    }

    public void jobChangeStatus(String job_id, String application, String status) {
        ReportEntry log = ReportEntry.create("job_status", job_id);
        log.application = application;
        log.status = status;
        this.addEvent(log);
    }

    public void output() throws ReportException {
        if (this.reportsPath == null) {
            throw new ReportException("reportPath variable must be set before creating reports!");
        }
        this.createReport();
    }

    public void cleanup() throws ReportException {
        this.cleanup(this.cleanupAgeHour);
    }

    public void cleanup(long age_hour) throws ReportException {
        if (this.isdisabled()) {
            return;
        }
        if (this.reportsPath == null) {
            throw new ReportException("reportPath variable must be set before creating reports!");
        }
        File file = new File(this.getReportsPath());
        assert (file.exists());
        assert (file.isDirectory());
        long threshold = System.currentTimeMillis() - age_hour * 60L * 60L * 1000L;
        for (File fp : file.listFiles()) {
            if (fp.lastModified() > threshold) continue;
            fp.delete();
            log.debug((Object)("delete old file: " + fp.getAbsolutePath()));
        }
    }

    synchronized void createReport() throws ReportException {
        if (this.isdisabled()) {
            return;
        }
        if (this.list.size() == 0) {
            return;
        }
        FileWriter file_writer = null;
        long millis = System.currentTimeMillis();
        File file = new File(this.reportsPath, "report_" + String.valueOf(millis) + ".xml");
        try {
            file_writer = new FileWriter(file);
        }
        catch (Exception e) {
            throw new ReportException("error while creating new XML document: '" + file.getAbsolutePath() + "'", e);
        }
        Element root = new Element("report");
        root.setAttribute("timestamp", String.valueOf(millis));
        root.setAttribute("timezone", "GMT");
        root.setAttribute("version", version);
        int count = 0;
        while (this.list.size() > 0) {
            Element element;
            ReportEntry entry = this.list.remove(0);
            ++count;
            Element metric_data = new Element("metric_data");
            if (entry.dt != null) {
                element = new Element("dt");
                element.setText(entry.dt);
                metric_data.addContent((Content)element);
            }
            if (entry.event != null) {
                element = new Element("event");
                element.setText(entry.event);
                metric_data.addContent((Content)element);
            }
            if (entry.job_id != null) {
                element = new Element("job_id");
                element.setText(entry.job_id);
                metric_data.addContent((Content)element);
            }
            if (entry.application != null) {
                element = new Element("application");
                element.setText(entry.application);
                metric_data.addContent((Content)element);
            }
            if (entry.status != null) {
                element = new Element("status");
                if (entry.status.endsWith("$")) {
                    entry.status.replace("$", "");
                }
                element.setText(entry.status);
                metric_data.addContent((Content)element);
            }
            if (entry.input_grid_name != null) {
                element = new Element("input_grid_name");
                element.setText(entry.input_grid_name);
                metric_data.addContent((Content)element);
            }
            if (entry.output_grid_name != null) {
                element = new Element("output_grid_name");
                element.setText(entry.output_grid_name);
                metric_data.addContent((Content)element);
            }
            if (entry.output_job_id != null) {
                element = new Element("job_id_bridge");
                element.setText(entry.output_job_id);
                metric_data.addContent((Content)element);
            }
            root.addContent((Content)metric_data);
        }
        Document doc = new Document(root);
        try {
            XMLOutputter serializer = new XMLOutputter();
            serializer.setFormat(Format.getPrettyFormat());
            serializer.output(doc, (Writer)file_writer);
            file_writer.flush();
            file_writer.close();
        }
        catch (Exception e) {
            throw new ReportException("Error while writing XML document '" + file.getAbsolutePath() + "'!", e);
        }
        log.debug((Object)("Write " + String.valueOf(count) + " events to " + file.getAbsolutePath()));
    }

    File relativPath(String relativ) throws MalformedURLException {
        int idx;
        assert (relativ != null);
        if (relativ.startsWith("file://")) {
            relativ = relativ.substring(0, 7);
        }
        if ((idx = relativ.indexOf("://")) != -1) {
            throw new MalformedURLException("url is not local file: '" + relativ + "'");
        }
        if (relativ.charAt(0) != File.separatorChar) {
            return new File(System.getProperty("user.dir"), relativ);
        }
        return new File(relativ);
    }

    boolean lazyCreateDir(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

