/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.monitoring;

import java.text.SimpleDateFormat;
import java.util.Date;

class ReportEntry {
    public String dt = null;
    public String event = null;
    public String job_id = null;
    public String application = null;
    public String status = null;
    public String input_grid_name = null;
    public String output_grid_name = null;
    public String output_job_id = null;

    public ReportEntry() {
    }

    public ReportEntry(String dt, String event, String job_id, String app, String status, String input_grid_name, String output_grid_name) {
        this.dt = dt;
        this.event = event;
        this.job_id = job_id;
        this.application = app;
        this.status = status;
        this.input_grid_name = input_grid_name;
        this.output_grid_name = output_grid_name;
    }

    public static ReportEntry create(String event, String job_id) {
        ReportEntry result = new ReportEntry();
        result.dt = ReportEntry.dateToString(new Date());
        result.event = event;
        result.job_id = job_id;
        return result;
    }

    public static String dateToString(Date d) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(d);
    }

    public String toString() {
        return this.dt + "-" + this.event + "-" + this.job_id;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dt);
        sb.append(" - ");
        sb.append(this.event);
        sb.append(" - ");
        sb.append(this.job_id);
        sb.append(" (app: ");
        sb.append(this.application);
        sb.append(" )");
        sb.append(" status=");
        sb.append(this.status);
        sb.append(", input_grid=");
        sb.append(this.input_grid_name);
        sb.append(", output_grid=");
        sb.append(this.output_grid_name);
        return sb.toString();
    }
}

