/*
 * Decompiled with CFR 0.152.
 */
package de.pc2.unicore.edgi.idb;

import de.fzj.unicore.xnjs.Configuration;
import de.fzj.unicore.xnjs.ems.ExecutionException;
import de.fzj.unicore.xnjs.management.Lifecycle;
import de.pc2.unicore.edgi.idb.ApplicationRepositoryException;
import de.pc2.unicore.edgi.xnjs.UtilConfigWrapper;
import eu.unicore.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

@Lifecycle(isSingleton=true)
public class ApplicationRepository {
    private static final Logger log = Log.getLogger((String)"unicore.xnjs", ApplicationRepository.class);
    public static final String MODE_KEY_NOFILES = "ignore_appfiles";
    public static final String NOOP_TAG = "disable";
    private final String urlar;
    private final String dgid;
    private final Object lock = new Object();
    private final Map<String, App> apps = new HashMap<String, App>();
    private final Map<String, Impl> impls = new HashMap<String, Impl>();
    private boolean isModeNoFiles = false;
    private final Configuration config;

    public ApplicationRepository(Configuration conf) throws ExecutionException {
        this.config = conf;
        UtilConfigWrapper helper = new UtilConfigWrapper(conf, log);
        this.urlar = helper.getProperty("AR.url", NOOP_TAG);
        this.dgid = helper.getProperty("DGTSI.dg", "");
        this.initAutomaticUpdate(helper);
    }

    private void initAutomaticUpdate(UtilConfigWrapper helper) throws ExecutionException {
        if (NOOP_TAG.equals(this.urlar)) {
            log.info((Object)"Automatic IDB update from application repository is disabled.");
            return;
        }
        final String filePath = helper.getProperty("XNJS.idbfile", null);
        if (filePath == null) {
            throw new ExecutionException("IDB file not defined");
        }
        int interval = helper.getPropertyInt("AR.frequence", 1440);
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream os = null;
                try {
                    ApplicationRepository.this.update();
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    ApplicationRepository.this.write(output);
                    os = new FileOutputStream(filePath);
                    os.write(output.toByteArray());
                }
                catch (Exception e) {
                    Log.logException((String)"exception while processing repository-idb-update", (Throwable)e, (Logger)log);
                }
                finally {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        this.config.getScheduledExecutor().scheduleWithFixedDelay(r, interval * 60, interval * 60, TimeUnit.SECONDS);
        r.run();
    }

    public String getUrlAr() {
        return this.urlar;
    }

    public String getDgId() {
        return this.dgid;
    }

    public Collection<App> getAllApp() {
        return this.apps.values();
    }

    public Impl getImplByShortcut(String shortcut) throws ApplicationRepositoryException {
        Impl result = this.impls.get(shortcut);
        if (result == null) {
            String[] col = shortcut.split(":", 0);
            result = this.update(col[0], col[1]);
        }
        return result;
    }

    public App getAppByShortcut(String shortcut) {
        String[] col = shortcut.split(":", 0);
        return this.apps.get(col[0]);
    }

    public Impl update(String appID, String implID) throws ApplicationRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            String[] cols;
            ArrayList<String> lines = null;
            App app = this.apps.get(appID);
            if (app == null) {
                lines = this.query("/getapps");
                for (String line : lines) {
                    String[] cols2 = line.split(" ");
                    if (cols2.length < 2 || !cols2[0].equals(appID)) continue;
                    app = new App(cols2[0], cols2[1]);
                    this.apps.put(app.id, app);
                }
                if (app == null) {
                    throw new ApplicationRepositoryException("appID = '" + appID + "' doesnt exist or has no implementation in application repository.");
                }
            }
            if ((lines = this.query("/getimpattr?impids=" + implID)).size() == 0) {
                throw new ApplicationRepositoryException("appID:implID = '" + appID + ":" + implID + "' doesn't exist or has no attributes in application repository.:\n   " + this.getUrlAr() + "/getimpattr?impids=" + implID);
            }
            String shortcut = appID + ":" + implID;
            Impl impl = this.impls.get(shortcut);
            if (impl == null) {
                impl = new Impl(implID);
            }
            for (String line : lines) {
                cols = line.split(" ", 0);
                impl.addAttrFromLine(cols[1]);
            }
            if (this.dgid == null || impl.isDGIDset(this.dgid)) {
                if (!this.isModeNoFiles()) {
                    return impl;
                }
                this.impls.put(shortcut, impl);
                app.impls.add(impl);
                lines = this.query("/getfileurls?impids=" + impl.id);
                for (String line : lines) {
                    cols = line.split(" ", 0);
                    impl.addFileFromLine(cols[1]);
                }
                return impl;
            }
            throw new ApplicationRepositoryException("appID:implID = '" + appID + ":" + implID + "' is not part of the dgid = '" + this.dgid + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws ApplicationRepositoryException {
        Object object = this.lock;
        synchronized (object) {
            Impl i3;
            App a;
            String[] cols;
            if (this.isDeactive()) {
                return;
            }
            this.impls.clear();
            this.apps.clear();
            ArrayList<String> lines = this.query("/getapps");
            String ids_str = "";
            HashMap<String, App> apps = new HashMap<String, App>();
            HashMap<String, Impl> impls = new HashMap<String, Impl>();
            for (String line : lines) {
                cols = line.split(" ");
                if (cols.length < 2) continue;
                a = new App(cols[0], cols[1]);
                apps.put(a.id, a);
                ids_str = ids_str + a.id + "+";
            }
            lines = this.query("/getimps?appids=" + ids_str);
            ids_str = "";
            for (String line : lines) {
                cols = line.split(" ");
                if (cols.length < 2) continue;
                a = (App)apps.get(cols[0]);
                assert (a != null) : "data inconsistency";
                Impl i2 = new Impl(cols[1]);
                impls.put(i2.id, i2);
                a.impls.add(i2);
                ids_str = ids_str + i2.id + "+";
            }
            lines = this.query("/getimpattr?impids=" + ids_str);
            for (String line : lines) {
                cols = line.split(" ", 2);
                i3 = (Impl)impls.get(cols[0]);
                assert (i3 != null) : "data inconsistency";
                i3.addAttrFromLine(cols[1]);
            }
            if (this.dgid != null) {
                ids_str = "";
                Iterator iter_app = apps.values().iterator();
                while (iter_app.hasNext()) {
                    App app = (App)iter_app.next();
                    Iterator<Impl> iter = app.impls.iterator();
                    while (iter.hasNext()) {
                        i3 = iter.next();
                        if (!i3.isDGIDset(this.dgid)) {
                            impls.remove(i3.id);
                            iter.remove();
                            continue;
                        }
                        ids_str = ids_str + i3.id + "+";
                    }
                    if (!app.impls.isEmpty()) continue;
                    iter_app.remove();
                }
            }
            if (!this.isModeNoFiles() && ids_str.length() > 0) {
                lines = this.query("/getfileurls?impids=" + ids_str);
                for (String line : lines) {
                    cols = line.split(" ", 0);
                    i3 = (Impl)impls.get(cols[0]);
                    assert (i3 != null) : "data inconsistency";
                    i3.addFileFromLine(cols[1]);
                }
            }
            for (App a2 : apps.values()) {
                this.apps.put(a2.id, a2);
                for (Impl i3 : a2.impls) {
                    this.impls.put(a2.id + ":" + i3.id, i3);
                }
            }
        }
    }

    public void addImpl(App a, Impl i) {
        this.apps.put(a.id, a);
        a.impls.add(i);
        this.impls.put(a.id + ":" + i.id, i);
    }

    public boolean isDeactive() {
        return NOOP_TAG.equals(this.urlar);
    }

    private ArrayList<String> query(String request) throws ApplicationRepositoryException {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.isDeactive()) {
            return ret;
        }
        try {
            String line;
            URL url = new URL(this.urlar + request);
            URLConnection conn = url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                ret.add(line);
            }
            if (ret.size() > 0 && ret.get(0).indexOf("Exception") != -1) {
                StringBuilder sb = new StringBuilder();
                sb.append("remote exception while quering ApplicationRepository\n");
                sb.append("QUERY: '" + url.toExternalForm() + "'\n");
                sb.append("ANWSER: \n");
                for (String x : ret) {
                    sb.append("| " + x + "\n");
                }
                throw new ApplicationRepositoryException(sb.toString());
            }
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("query Appplication Repository:\n");
                sb.append("QUERY: '" + url.toExternalForm() + "'\n");
                sb.append("ANWSER: \n");
                if (ret.size() > 0) {
                    for (String x : ret) {
                        sb.append("| " + x + "\n");
                    }
                } else {
                    sb.append("| <empty return>\n");
                }
                log.debug((Object)sb.toString());
            }
            return ret;
        }
        catch (IOException e) {
            e.printStackTrace();
            return ret;
        }
    }

    public String debugString(Impl impl, App app) {
        StringBuilder sb = new StringBuilder();
        sb.append("AppRep-URL = ");
        sb.append(this.urlar);
        sb.append("\n");
        sb.append("  desktop-grid = ");
        sb.append(this.dgid);
        sb.append("\n");
        sb.append("  impl = ");
        sb.append(impl != null ? impl.id : "null");
        sb.append("\n");
        if (impl != null) {
            for (Map.Entry<String, Object> entry : impl.attr.entrySet()) {
                sb.append("  attr '");
                sb.append(entry.getKey());
                sb.append("' : '");
                sb.append(entry.getValue());
                sb.append("'");
                sb.append("\n");
            }
            for (String string : impl.files) {
                sb.append("  files '");
                sb.append(string);
                sb.append("'");
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream os) {
        Object object = this.lock;
        synchronized (object) {
            PrintWriter pw = new PrintWriter(os);
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            pw.println("<idb:IDB xmlns:idb=\"http://www.fz-juelich.de/unicore/xnjs/idb\">");
            pw.println("\n <!-- application -->\n");
            for (App app : this.apps.values()) {
                int impl_count = 0;
                for (Impl impl : app.impls) {
                    String desc;
                    String shortcut = app.id + ":" + impl.id;
                    String name = app.name;
                    if (++impl_count > 1) {
                        name = name + "_" + Integer.toString(impl_count);
                    }
                    if ((desc = impl.getDescription()) == null) {
                        desc = "n/a";
                    }
                    assert (this.impls.containsKey(shortcut));
                    pw.println("  <idb:IDBApplication>");
                    pw.println("    <idb:ApplicationName>" + name + "</idb:ApplicationName>");
                    pw.println("    <idb:ApplicationVersion></idb:ApplicationVersion>");
                    pw.println("    <idb:ApplicationDescription>" + desc + "</idb:ApplicationDescription>");
                    pw.println("    <jsdl:POSIXApplication xmlns:jsdl=\"http://schemas.ggf.org/jsdl/2005/11/jsdl-posix\">");
                    pw.println("      <jsdl:Executable>" + shortcut + "</jsdl:Executable>");
                    pw.println("    </jsdl:POSIXApplication>");
                    pw.println("  </idb:IDBApplication>");
                }
            }
            pw.println("  <idb:TargetSystemProperties>");
            pw.println("    <jsdl:Resources xmlns:jsdl=\"http://schemas.ggf.org/jsdl/2005/11/jsdl\">");
            pw.println("     <jsdl:OperatingSystem>");
            pw.println("      <jsdl:OperatingSystemType>");
            pw.println("        <jsdl:OperatingSystemName></jsdl:OperatingSystemName>");
            pw.println("      </jsdl:OperatingSystemType>");
            pw.println("      <jsdl:OperatingSystemVersion>0</jsdl:OperatingSystemVersion>");
            pw.println("      <jsdl:Description>desktop grid " + this.dgid + " application repository: " + this.urlar + "</jsdl:Description>");
            pw.println("     </jsdl:OperatingSystem>");
            pw.println("      <jsdl:CPUArchitecture>");
            pw.println("        <jsdl:CPUArchitectureName>x86</jsdl:CPUArchitectureName>");
            pw.println("      </jsdl:CPUArchitecture>");
            pw.println("      <jsdl:IndividualCPUCount>");
            pw.println("        <jsdl:Exact>1.0</jsdl:Exact>");
            pw.println("      </jsdl:IndividualCPUCount>");
            pw.println("      <jsdl:TotalCPUCount>");
            pw.println("        <jsdl:Exact>1.0</jsdl:Exact>");
            pw.println("      </jsdl:TotalCPUCount>");
            pw.println("      <jsdl:IndividualPhysicalMemory>");
            pw.println("        <jsdl:Exact>2</jsdl:Exact>");
            pw.println("      </jsdl:IndividualPhysicalMemory>");
            pw.println("    </jsdl:Resources>");
            pw.println("  </idb:TargetSystemProperties>");
            pw.println("</idb:IDB>");
            pw.flush();
        }
    }

    private boolean isModeNoFiles() {
        return this.isModeNoFiles;
    }

    public static class App {
        public String id;
        public String name;
        public ArrayList<Impl> impls;

        public App(String id, String name) {
            this.id = id;
            this.name = name;
            this.impls = new ArrayList();
        }
    }

    public static class Impl {
        public static String[] DGID_NAME = new String[]{"desktop-grid-ids", "dg", "dg-ids"};
        public String id = null;
        public Map<String, Object> attr = new HashMap<String, Object>();
        public ArrayList<String> files = new ArrayList();
        public ArrayList<DGID> dgids = new ArrayList();

        public Impl(String id) {
            this.id = id;
        }

        public void addAttrFromLine(String line) {
            String[] cols = line.split("=", 0);
            if (cols.length >= 2) {
                if (cols[0].equals(DGID_NAME[0]) || cols[0].equals(DGID_NAME[1]) || cols[0].equals(DGID_NAME[2])) {
                    DGID.addToListFromString(this.dgids, cols[1]);
                } else if (cols[0].startsWith("VOs.vo")) {
                    this.attr.put(cols[0], cols[1]);
                } else {
                    this.attr.put(cols[0], cols[1]);
                }
            } else if (cols.length == 1) {
                this.attr.put(cols[0], null);
            }
        }

        public ArrayList<DGID> getDGIDs() {
            return this.dgids;
        }

        public String altName(String dg) {
            for (DGID dgid : this.dgids) {
                if (dgid.id.indexOf(dg) == -1) continue;
                return dgid.alt_name;
            }
            return null;
        }

        public boolean isDGIDset(String gdid) {
            assert (gdid != null);
            ArrayList<DGID> xs = this.getDGIDs();
            if (xs == null) {
                return false;
            }
            for (DGID x : xs) {
                if (!x.id.contains(gdid)) continue;
                return true;
            }
            return false;
        }

        public void addFileFromLine(String string) {
            this.files.add(string);
        }

        public String getDescription() {
            Object o = this.attr.get("Description");
            if (o == null) {
                return null;
            }
            return (String)o;
        }
    }

    public static class DGID {
        static final String ID_DELIMITER = " ";
        static final String ALT_NAME_DELIMITER = ";";
        public String id;
        public String alt_name;

        public DGID(String id, String alt_name) {
            this.id = id;
            this.alt_name = alt_name;
        }

        public static void addToListFromString(ArrayList<DGID> dgids, String value) {
            String[] tokens;
            for (String token : tokens = value.split(ID_DELIMITER)) {
                String[] idsplit = token.split(ALT_NAME_DELIMITER);
                if (idsplit.length > 1) {
                    dgids.add(new DGID(idsplit[0], idsplit[1]));
                    continue;
                }
                assert (idsplit.length == 1);
                dgids.add(new DGID(idsplit[0], null));
            }
        }

        public String toString() {
            return "<GDID '" + this.id + "' or '" + this.alt_name + "'>";
        }
    }
}

