/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.assertion;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.samly2.SAMLUtils;
import eu.unicore.samly2.exceptions.SAMLParseException;
import eu.unicore.security.dsig.DSigException;
import eu.unicore.security.dsig.DigSignatureUtil;
import eu.unicore.security.dsig.IdAttribute;
import eu.unicore.security.dsig.Utils;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import xmlbeans.org.oasis.saml2.assertion.AssertionDocument;
import xmlbeans.org.oasis.saml2.assertion.AssertionType;
import xmlbeans.org.oasis.saml2.assertion.AudienceRestrictionType;
import xmlbeans.org.oasis.saml2.assertion.ConditionAbstractType;
import xmlbeans.org.oasis.saml2.assertion.ConditionsType;
import xmlbeans.org.oasis.saml2.assertion.KeyInfoConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.NameIDType;
import xmlbeans.org.oasis.saml2.assertion.ProxyRestrictionType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationDataType;
import xmlbeans.org.oasis.saml2.assertion.SubjectConfirmationType;
import xmlbeans.org.oasis.saml2.assertion.SubjectType;
import xmlbeans.org.w3.x2000.x09.xmldsig.KeyInfoType;
import xmlbeans.org.w3.x2000.x09.xmldsig.X509DataType;

public abstract class AbstractAssertion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SAML_VALIDITY_GRACE_TIME = 180000;
    private static String ID_PREFIX = "SAMLY2lib_assert_";
    public static final IdAttribute ASSERTION_ID_QNAME = new IdAttribute(null, "ID");
    protected AssertionType assertion;
    private AssertionDocument assertionDoc;
    private ConditionsType conditions;
    private ProxyRestrictionType proxyRestriction;
    private AudienceRestrictionType audienceRestriction;
    private boolean modified = true;
    private int conditionsCount;
    private String issuerDN;
    private String subjectDN;

    public AbstractAssertion() {
        this.proxyRestriction = null;
        this.audienceRestriction = null;
        this.conditionsCount = 0;
        this.assertionDoc = AssertionDocument.Factory.newInstance();
        this.assertion = AssertionType.Factory.newInstance();
        this.assertion.setVersion("2.0");
        this.assertion.setIssueInstant(Calendar.getInstance());
        this.assertion.setID(SAMLUtils.genID(ID_PREFIX));
        this.conditions = ConditionsType.Factory.newInstance();
    }

    public AbstractAssertion(AssertionDocument doc) throws SAMLParseException, XmlException, IOException {
        this.assertionDoc = AssertionDocument.Factory.parse((Reader)doc.newReader());
        this.assertion = this.assertionDoc.getAssertion();
        if (this.assertion == null) {
            this.assertion = AssertionType.Factory.newInstance();
        }
        this.conditions = this.assertion.getConditions();
        this.proxyRestriction = null;
        this.audienceRestriction = null;
        if (this.conditions != null) {
            AudienceRestrictionType[] ar;
            ProxyRestrictionType[] pp = this.conditions.getProxyRestrictionArray();
            if (pp.length > 0) {
                this.proxyRestriction = pp[0];
            }
            if ((ar = this.conditions.getAudienceRestrictionArray()).length > 0) {
                this.audienceRestriction = ar[0];
            }
        } else {
            this.conditions = ConditionsType.Factory.newInstance();
        }
        NameIDType n1 = this.assertion.getIssuer();
        if (n1 != null) {
            if ("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals(n1.getFormat())) {
                XmlCursor cur = n1.newCursor();
                cur.toFirstContentToken();
                this.issuerDN = cur.getTextValue();
            }
        } else {
            throw new SAMLParseException("No issuer in assertion");
        }
        SubjectType s = this.assertion.getSubject();
        if (s != null && s.getNameID() != null && "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName".equals((n1 = s.getNameID()).getFormat())) {
            XmlCursor cur = n1.newCursor();
            cur.toFirstContentToken();
            this.subjectDN = cur.getTextValue();
        }
    }

    public void setX509Issuer(String issuerName) {
        String dn = X500NameUtils.getPortableRFC2253Form((String)issuerName);
        NameIDType issuerN = NameIDType.Factory.newInstance();
        issuerN.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        issuerN.setStringValue(dn);
        this.assertion.setIssuer(issuerN);
        this.issuerDN = dn;
        this.modified = true;
    }

    public void setIssuer(NameIDType issuer) {
        this.assertion.setIssuer(issuer);
        if (issuer.getFormat().equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            this.issuerDN = issuer.getStringValue();
        }
        this.modified = true;
    }

    public void setX509Subject(String subjectName) {
        String dn = X500NameUtils.getPortableRFC2253Form((String)subjectName);
        NameIDType subjectN = NameIDType.Factory.newInstance();
        subjectN.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName");
        subjectN.setStringValue(dn);
        SubjectType subjectT = SubjectType.Factory.newInstance();
        subjectT.setNameID(subjectN);
        this.assertion.setSubject(subjectT);
        this.subjectDN = dn;
        this.modified = true;
    }

    public void setSubject(NameIDType subject) {
        SubjectType subjectT = SubjectType.Factory.newInstance();
        subjectT.setNameID(subject);
        this.assertion.setSubject(subjectT);
        if (subject.getFormat().equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            this.subjectDN = subject.getStringValue();
        }
        this.modified = true;
    }

    public void setSubject(SubjectType subject) {
        if (this.assertion.isSetSubject()) {
            this.assertion.unsetSubject();
        }
        SubjectType added = this.assertion.addNewSubject();
        if (subject.isSetNameID()) {
            added.setNameID(subject.getNameID());
        }
        if (subject.isSetEncryptedID()) {
            added.setEncryptedID(subject.getEncryptedID());
        }
        if (subject.isSetBaseID()) {
            added.setBaseID(subject.getBaseID());
        }
        if (subject.sizeOfSubjectConfirmationArray() > 0) {
            added.setSubjectConfirmationArray(subject.getSubjectConfirmationArray());
        }
        if (subject.getNameID().getFormat().equals("urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName")) {
            this.subjectDN = subject.getNameID().getStringValue();
        }
        this.modified = true;
    }

    public void setHolderOfKeyConfirmation(X509Certificate[] certificates) throws CertificateEncodingException {
        this.setConfirmation(certificates, "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
    }

    public void setSenderVouchesX509Confirmation(X509Certificate[] certificates) throws CertificateEncodingException {
        this.setConfirmation(certificates, "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches");
    }

    private void setConfirmation(X509Certificate[] certificates, String method) throws CertificateEncodingException {
        SubjectType subject = this.assertion.getSubject();
        SubjectConfirmationType confirmation = subject.addNewSubjectConfirmation();
        confirmation.setMethod(method);
        KeyInfoConfirmationDataType confirData = KeyInfoConfirmationDataType.Factory.newInstance();
        KeyInfoType ki = DigSignatureUtil.generateX509KeyInfo(certificates);
        confirData.setKeyInfoArray(new KeyInfoType[]{ki});
        confirmation.setSubjectConfirmationData((SubjectConfirmationDataType)confirData);
    }

    public void updateIssueTime() {
        this.assertion.setIssueInstant(Calendar.getInstance());
    }

    public void setTimeConditions(Date notBefore, Date notOnOrAfter) {
        Calendar c = Calendar.getInstance();
        if (notBefore != null) {
            if (!this.conditions.isSetNotBefore()) {
                ++this.conditionsCount;
            }
            c.setTime(notBefore);
            this.conditions.setNotBefore(c);
        } else if (this.conditions.isSetNotBefore()) {
            --this.conditionsCount;
            this.conditions.unsetNotBefore();
        }
        if (notOnOrAfter != null) {
            if (!this.conditions.isSetNotOnOrAfter()) {
                ++this.conditionsCount;
            }
            c.setTime(notOnOrAfter);
            this.conditions.setNotOnOrAfter(c);
            ++this.conditionsCount;
        } else if (this.conditions.isSetNotOnOrAfter()) {
            --this.conditionsCount;
            this.conditions.unsetNotOnOrAfter();
        }
        this.modified = true;
    }

    public boolean checkTimeConditions(Date time) {
        long t = time.getTime();
        if (this.getNotBefore() != null && this.getNotBefore().getTime() > t + 180000L) {
            return false;
        }
        return this.getNotOnOrAfter() == null || this.getNotOnOrAfter().getTime() > t - 180000L;
    }

    public boolean checkTimeConditions() {
        return this.checkTimeConditions(new Date());
    }

    public void setProxyRestriction(int value) {
        if (value > 0) {
            if (this.proxyRestriction == null) {
                this.proxyRestriction = this.conditions.addNewProxyRestriction();
                ++this.conditionsCount;
            }
            this.proxyRestriction.setCount(BigInteger.valueOf(value));
        } else if (this.proxyRestriction != null) {
            this.conditions.removeProxyRestriction(0);
            this.proxyRestriction = null;
            --this.conditionsCount;
        }
        this.modified = true;
    }

    public void setAudienceRestriction(String[] audienceArray) {
        if (audienceArray != null) {
            if (this.audienceRestriction == null) {
                this.audienceRestriction = this.conditions.addNewAudienceRestriction();
                ++this.conditionsCount;
            }
            this.audienceRestriction.setAudienceArray(audienceArray);
        } else if (this.audienceRestriction != null) {
            this.conditions.removeAudienceRestriction(0);
            this.audienceRestriction = null;
            --this.conditionsCount;
        }
        this.modified = true;
    }

    public void addCustomCondition(XmlObject condition) {
        ConditionAbstractType newCondition = this.conditions.addNewCondition();
        newCondition.set(condition);
        XmlCursor cur = newCondition.newCursor();
        cur.toNextToken();
        QName type = condition.schemaType().getName();
        if (type == null) {
            type = condition.schemaType().getDocumentElementName();
        }
        String prefix = cur.prefixForNamespace(type.getNamespaceURI());
        cur.insertNamespace(prefix, type.getNamespaceURI());
        cur.insertAttributeWithValue("type", "http://www.w3.org/2001/XMLSchema-instance", prefix + ":" + type.getLocalPart());
        cur.dispose();
        ++this.conditionsCount;
        this.modified = true;
    }

    public void sign(PrivateKey pk) throws DSigException {
        this.sign(pk, null);
    }

    public void sign(PrivateKey pk, X509Certificate[] cert) throws DSigException {
        DigSignatureUtil sign = new DigSignatureUtil();
        AssertionDocument unsignedDoc = this.getXML();
        Document docToSign = SAMLUtils.getDOM((XmlObject)unsignedDoc);
        NodeList nodes = docToSign.getFirstChild().getChildNodes();
        Node sibling = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getLocalName() == null || !n.getLocalName().equals("Subject")) continue;
            sibling = n;
            break;
        }
        sign.genEnvelopedSignature(pk, null, cert, docToSign, sibling, ASSERTION_ID_QNAME);
        try {
            this.assertionDoc = AssertionDocument.Factory.parse((Node)docToSign);
        }
        catch (XmlException e) {
            throw new DSigException("Parsing signed document failed", e);
        }
        this.assertion = this.assertionDoc.getAssertion();
    }

    public boolean isSigned() {
        return this.assertionDoc.getAssertion().getSignature() != null && !this.assertionDoc.getAssertion().getSignature().isNil();
    }

    public boolean isCorrectlySigned(PublicKey key) throws DSigException {
        if (!this.isSigned()) {
            return false;
        }
        DigSignatureUtil sign = new DigSignatureUtil();
        Document doc = (Document)this.getXML().getDomNode();
        return sign.verifyEnvelopedSignature(doc, Collections.singletonList(doc.getDocumentElement()), ASSERTION_ID_QNAME, key);
    }

    public X509Certificate[] getIssuerFromSignature() {
        return SAMLUtils.getIssuerFromSignature(this.assertion.getSignature());
    }

    public X509Certificate[] getSubjectFromConfirmation() {
        KeyInfoConfirmationDataType confirData;
        SubjectType subject = this.assertion.getSubject();
        if (subject == null) {
            return null;
        }
        SubjectConfirmationType[] tt = subject.getSubjectConfirmationArray();
        if (tt == null || tt.length == 0) {
            return null;
        }
        SubjectConfirmationType confirmation = tt[0];
        if (confirmation == null) {
            return null;
        }
        try {
            confirData = (KeyInfoConfirmationDataType)confirmation.getSubjectConfirmationData();
        }
        catch (ClassCastException e) {
            return null;
        }
        if (confirData == null) {
            return null;
        }
        KeyInfoType ki = confirData.getKeyInfoArray(0);
        if (ki == null) {
            return null;
        }
        X509DataType[] x509Data = ki.getX509DataArray();
        if (x509Data == null) {
            return null;
        }
        for (int i = 0; i < x509Data.length; ++i) {
            if (x509Data[i].getX509CertificateArray().length <= 0) continue;
            return Utils.deserializeCertificateChain(x509Data[i].getX509CertificateArray());
        }
        return null;
    }

    public AssertionDocument getXML() {
        if (this.modified) {
            if (this.conditionsCount > 0) {
                this.assertion.setConditions(this.conditions);
            }
            this.assertionDoc.setAssertion(this.assertion);
            this.modified = false;
        }
        return this.assertionDoc;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public int getProxyRestriction() {
        if (this.proxyRestriction == null) {
            return -1;
        }
        return this.proxyRestriction.getCount().intValue();
    }

    public Date getNotBefore() {
        Calendar c = this.conditions.getNotBefore();
        return c == null ? null : c.getTime();
    }

    public Date getNotOnOrAfter() {
        Calendar c = this.conditions.getNotOnOrAfter();
        return c == null ? null : c.getTime();
    }

    public ConditionAbstractType[] getCustomConditions() {
        return this.conditions.getConditionArray();
    }
}

