/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb;

import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.codehaus.xfire.util.Base64;

public class X509Utils {
    private static final String X509BEGIN_TOKEN = "-----BEGIN CERTIFICATE-----\n";
    private static final String X509END_TOKEN = "\n-----END CERTIFICATE-----";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadCertificate(String file) throws IOException {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(file));
            X509Certificate x509Certificate = CertificateUtils.loadCertificate((InputStream)bis, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            return x509Certificate;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static String getStringFromPEMFile(String pemFile) throws IOException {
        X509Certificate cert = X509Utils.loadCertificate(pemFile);
        return X509Utils.getPEMStringFromX509(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate getX509FromPEMString(String pemstr) throws IOException {
        if (pemstr == null) {
            return null;
        }
        String work = X509BEGIN_TOKEN + pemstr + X509END_TOKEN;
        ByteArrayInputStream bis = new ByteArrayInputStream(work.getBytes());
        try {
            X509Certificate x509Certificate = CertificateUtils.loadCertificate((InputStream)bis, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            return x509Certificate;
        }
        finally {
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static String getPEMStringFromX509(Certificate x509) throws IOException {
        byte[] coded;
        try {
            coded = x509.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new IOException("Can't encode the certificate, shouldn't happen", e);
        }
        byte[] base64 = Base64.encode((byte[])coded).getBytes();
        String ret = new String(base64);
        return ret;
    }
}

