/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.xuudb;

import eu.unicore.security.canl.TruststoreProperties;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractConfiguration
extends PropertiesHelper {
    public static final String PROP_PREFIX = "xuudb.";
    public static final String PROP_ADDRESS = "address";
    public static final String DEFAULT_ADDRESS = "http://localhost:34463";

    public AbstractConfiguration(String prefix, Properties properties, Map<String, PropertyMD> defaults, Logger log) throws ConfigurationException {
        super(prefix, properties, defaults, log);
    }

    protected void checkConfigFile(File config, Logger logger) throws IOException {
        String updateInfo = this.createConfigUpdateHint();
        if (updateInfo.length() > 0) {
            logger.error((Object)("The configuration in the " + config + " file uses the obsolete syntax." + " Please consult the documentation and perform the suggested updates:\n" + updateInfo));
            throw new IOException("Obsolete syntax in the configuration file was detected");
        }
        logger.info((Object)("Loaded Configuration from file: " + config.getPath()));
    }

    protected abstract String createConfigUpdateHint();

    protected void createCommonConfigUpdateHint(StringBuilder newOnes, StringBuilder oldOnes) {
        String oldType;
        String KEYSTORE = "xuudb_keystore_file";
        String KEYSTOREPASSWORD = "xuudb_keystore_password";
        String KEYSTORETYPE = "xuudb_keystore_type";
        String TRUSTSTORE = "xuudb_truststore_file";
        String TRUSTSTOREPASSWORD = "xuudb_truststore_password";
        String TRUSTSTORETYPE = "xuudb_truststore_type";
        String HTTPPORT = "xuudb_http_port";
        String HTTPHOST = "xuudb_http_host";
        String USESSL = "xuudb_use_ssl";
        if (this.properties.getProperty("xuudb_http_host") != null) {
            oldOnes.append("xuudb_http_port").append("\n");
            oldOnes.append("xuudb_http_host").append("\n");
            oldOnes.append("xuudb_use_ssl").append("\n");
            newOnes.append("xuudb.address=" + this.properties.getProperty("xuudb_http_host") + ":" + this.properties.getProperty("xuudb_http_port"));
        }
        if (this.properties.getProperty("xuudb_keystore_file") != null) {
            oldOnes.append("xuudb_keystore_file").append("\n");
            oldOnes.append("xuudb_keystore_password").append("\n");
            oldOnes.append("xuudb_keystore_type").append("\n");
            newOnes.append("credential.keyPath=" + this.properties.getProperty("xuudb_keystore_file"));
            oldType = this.properties.getProperty("xuudb_keystore_type");
            if (oldType == null) {
                oldType = "JKS";
            }
            newOnes.append("credential.format=" + oldType);
            newOnes.append("credential.password=<YOUR_CURRENT_KEYSTORE_PASSWORD (not written to log for security reasons)>");
        }
        if (this.properties.getProperty("xuudb_truststore_file") != null) {
            oldOnes.append("xuudb_truststore_file").append("\n");
            oldOnes.append("xuudb_truststore_type").append("\n");
            oldOnes.append("xuudb_truststore_password").append("\n");
            newOnes.append("truststore.type=" + TruststoreProperties.TruststoreType.keystore);
            newOnes.append("truststore.keystorePath=" + this.properties.getProperty("xuudb_truststore_file"));
            oldType = this.properties.getProperty("xuudb_truststore_type");
            if (oldType == null) {
                oldType = "JKS";
            }
            newOnes.append("truststore.keystoreFormat=" + oldType);
            newOnes.append("truststore.keystorePassword=<YOUR_CURRENT_TRUSTSTORE_PASSWORD (not written to log for security reasons)>");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

