/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.debug;

import java.io.PrintStream;

public class Debug {
    public static int debugLevel = 0;
    public static PrintStream out = System.err;

    static {
        String lv = null;
        lv = System.getProperty("org.globus.debug.level");
        if (lv != null) {
            Debug.setDebugLevel(lv);
        } else {
            lv = System.getProperty("DEBUG_LEVEL");
            if (lv != null) {
                Debug.setDebugLevel(lv);
            }
        }
    }

    private static void setDebugLevel(String value) {
        Integer i = new Integer(value);
        debugLevel = i;
    }

    public static void println(String msg) {
        out.println(msg);
    }

    public static void print(String msg) {
        out.print(msg);
    }

    public static void error(String msg) {
        Debug.error(msg, null);
    }

    public static void error(String msg, Exception ex) {
        System.err.println(msg);
        if (debugLevel >= 3 && ex != null) {
            ex.printStackTrace();
        }
    }

    public static void debug(String msg) {
        Debug.debug(1, msg);
    }

    public static void debug(int level, String msg) {
        if (level <= debugLevel) {
            out.println(msg);
        }
    }

    public static void debug(int level, String header, String msg) {
        if (level <= debugLevel) {
            out.println(String.valueOf(header) + msg);
        }
    }

    public static void debug(int level, String msg, Exception e) {
        if (level <= debugLevel) {
            System.err.println(msg);
            if (level >= 3 && e != null) {
                e.printStackTrace();
            }
        }
    }
}

