/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds.gsi.netscape;

import com.netscape.sasl.SaslClient;
import com.netscape.sasl.SaslException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.mds.gsi.common.GSIMechanism;
import org.ietf.jgss.GSSException;

public class GSIMech
extends GSIMechanism
implements SaslClient {
    private static Log logger = LogFactory.getLog((String)GSIMech.class.getName());

    public GSIMech(String authzID, String protocol, String serverName, Map props, CallbackHandler cbh) throws SaslException {
        if (props != null) {
            String prop = (String)props.get("javax.security.sasl.maxbuffer");
            if (prop != null) {
                try {
                    this.recvMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((prop = (String)props.get("javax.security.sasl.sendmaxbuffer")) != null) {
                try {
                    this.sendMaxBufSize = Integer.parseInt(prop);
                }
                catch (NumberFormatException e) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        }
        try {
            this.init(serverName, props);
        }
        catch (Exception e) {
            throw new SaslException("Failed to initialize.", (Throwable)e);
        }
    }

    public byte[] createInitialResponse() throws SaslException {
        try {
            return this.context.initSecContext(null, 0, 0);
        }
        catch (GSSException e) {
            throw new SaslException("createInitialRespose failed", (Throwable)e);
        }
    }

    public byte[] evaluateChallenge(byte[] challengeData) throws SaslException {
        if (challengeData == null) {
            logger.debug((Object)"SASL received null challenge data. Returning empty array.");
            return new byte[0];
        }
        byte[] token = null;
        try {
            token = this.exchangeData(challengeData);
        }
        catch (GSSException e) {
            throw new SaslException("evaluateChanllenge failed", (Throwable)e);
        }
        catch (Exception e) {
            throw new SaslException("evaluateChanllenge failed", (Throwable)e);
        }
        return token;
    }
}

