/*
 * Decompiled with CFR 0.152.
 */
package org.globus.mds;

import java.util.Enumeration;
import java.util.Hashtable;
import org.globus.mds.MDS;
import org.globus.mds.MDSException;
import org.globus.mds.MDSResult;

public class MDSTest1 {
    private int errorCount = 0;
    MDSResult mdsResult;
    Hashtable v;

    public void run(String host, String port, String dn) {
        MDS mds = new MDS(host, port);
        try {
            try {
                mds.connect();
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            try {
                this.mdsResult = mds.getAttributes(dn);
                this.mdsResult.print();
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
            System.out.println("---");
            mds.setSearchLimit(10);
            try {
                this.v = mds.search(dn, "(objectclass=*)", new String[]{"objectclass", "domainname"}, 1);
                Enumeration e = this.v.keys();
                while (e.hasMoreElements()) {
                    dn = (String)e.nextElement();
                    this.mdsResult = (MDSResult)this.v.get(dn);
                    System.out.println("DN: " + dn);
                    System.out.println("...domain: " + this.mdsResult.getFirstValue("domainname"));
                }
            }
            catch (MDSException e) {
                System.err.println("MDS error:" + e.getMessage() + " " + e.getLdapMessage());
                ++this.errorCount;
                try {
                    mds.disconnect();
                }
                catch (MDSException mDSException) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                mds.disconnect();
            }
            catch (MDSException mDSException) {}
        }
    }

    public void printResults() {
        if (this.errorCount == 0) {
            System.out.println("\n{test} MDS TEST 1: succeeded");
        } else {
            System.out.println("\n{test} MDS TEST 1: failed -- " + this.errorCount + " error(s) encountered");
        }
    }

    public static void main(String[] argv) {
        if (argv.length < 3) {
            System.err.println("Usage: java MDSTest1 host port dn");
            System.exit(-1);
        }
        MDSTest1 mdsTest = new MDSTest1();
        mdsTest.run(argv[0], argv[1], argv[2]);
        mdsTest.printResults();
    }
}

