/*
 * Decompiled with CFR 0.152.
 */
package org.globus.io.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedIOException;
import org.globus.io.gass.client.GassException;
import org.globus.io.gass.client.internal.GASSProtocol;
import org.globus.io.streams.GlobusOutputStream;
import org.globus.net.SocketFactory;
import org.globus.util.http.HttpResponse;

public class HTTPOutputStream
extends GlobusOutputStream {
    private static Log logger = LogFactory.getLog((String)HTTPOutputStream.class.getName());
    private static final byte[] CRLF = "\r\n".getBytes();
    private static final int DEFAULT_TIME = 3000;
    protected OutputStream output;
    protected InputStream in;
    protected Socket socket;
    protected long size = -1L;
    protected boolean append = false;

    protected HTTPOutputStream() {
    }

    public HTTPOutputStream(String host, int port, String file, long length, boolean append) throws GassException, IOException {
        this.init(host, port, file, length, append);
    }

    private void init(String host, int port, String file, long length, boolean append) throws GassException, IOException {
        this.size = length;
        this.append = append;
        int time = 3000;
        long st = System.currentTimeMillis();
        this.socket = SocketFactory.getDefault().createSocket(host, port);
        long et = System.currentTimeMillis();
        time = 2 * (int)(et - st);
        this.put(host, file, length, time);
    }

    private void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void put(String host, String file, long length, int waittime) throws IOException {
        this.output = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
        String msg = GASSProtocol.PUT(file, host, length, this.append);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("SENT: " + msg));
        }
        this.output.write(msg.getBytes());
        this.output.flush();
        if (waittime < 0) {
            int maxsleep = 3000;
            while (maxsleep != 0) {
                this.sleep(1000);
                maxsleep -= 1000;
                this.checkForReply();
            }
        } else {
            this.sleep(waittime);
        }
        this.checkForReply();
    }

    private void checkForReply() throws IOException {
        if (this.in.available() <= 0) {
            return;
        }
        HttpResponse reply = new HttpResponse(this.in);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("REPLY: " + reply));
        }
        if (reply.httpCode != 100) {
            this.abort();
            throw new IOException("Gass PUT failed: " + reply.httpMsg);
        }
        logger.debug((Object)"Received continuation reply");
    }

    private void finish() throws IOException {
        if (this.size == -1L) {
            String lHex = Integer.toHexString(0);
            this.output.write(lHex.getBytes());
            this.output.write(CRLF);
            this.output.write(CRLF);
        }
        this.output.flush();
    }

    private void closeSocket() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.output != null) {
                this.output.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void abort() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closeSocket();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        HttpResponse hd = new HttpResponse(this.in);
        this.closeSocket();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("REPLY: " + hd));
        }
        if (hd.httpCode != 200) {
            throw new ChainedIOException("Gass close failed.", new GassException("Gass PUT failed: " + hd.httpMsg));
        }
    }

    @Override
    public void write(byte[] msg) throws IOException {
        this.write(msg, 0, msg.length);
    }

    @Override
    public void write(byte[] msg, int from, int length) throws IOException {
        this.checkForReply();
        if (this.size == -1L) {
            String lHex = Integer.toHexString(length);
            this.output.write(lHex.getBytes());
            this.output.write(CRLF);
            this.output.write(msg, from, length);
            this.output.write(CRLF);
        } else {
            this.output.write(msg, from, length);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.checkForReply();
        if (this.size == -1L) {
            this.output.write("01".getBytes());
            this.output.write(CRLF);
            this.output.write(b);
            this.output.write(CRLF);
        } else {
            this.output.write(b);
        }
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }
}

