/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.jaas;

import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.globus.util.I18n;

public abstract class JaasSubject {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.gssapi.errors", JaasSubject.class.getClassLoader());
    private static JaasSubject subject;

    protected JaasSubject() {
    }

    public static synchronized JaasSubject getJaasSubject() {
        if (subject == null) {
            String className = System.getProperty("org.globus.jaas.provider");
            if (className == null) {
                className = "org.globus.gsi.jaas.GlobusSubject";
            }
            try {
                Class<?> clazz = Class.forName(className);
                if (!JaasSubject.class.isAssignableFrom(clazz)) {
                    throw new RuntimeException(i18n.getMessage("invalidJaasSubject", className));
                }
                subject = (JaasSubject)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.valueOf(i18n.getMessage("loadError", className)) + e.getMessage());
            }
            catch (InstantiationException e) {
                throw new RuntimeException(String.valueOf(i18n.getMessage("instanError", className)) + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.valueOf(i18n.getMessage("instanError", className)) + e.getMessage());
            }
        }
        return subject;
    }

    public abstract Subject getSubject();

    public abstract Object runAs(Subject var1, PrivilegedAction var2);

    public abstract Object runAs(Subject var1, PrivilegedExceptionAction var2) throws PrivilegedActionException;

    public static Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        return JaasSubject.getJaasSubject().runAs(subject, action);
    }

    public static Object doAs(Subject subject, PrivilegedAction action) {
        return JaasSubject.getJaasSubject().runAs(subject, action);
    }

    public static Subject getCurrentSubject() {
        return JaasSubject.getJaasSubject().getSubject();
    }
}

