/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.bc;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.x509.X509Name;
import org.globus.gsi.bc.BouncyCastleUtil;

public class X509NameHelper {
    private ASN1Sequence seq;

    public X509NameHelper(ASN1Sequence seq) {
        this.seq = seq;
    }

    public X509NameHelper(X509Name name) {
        try {
            this.seq = (ASN1Sequence)BouncyCastleUtil.duplicate(name.getDERObject());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public X509Name getAsName() {
        return new X509Name(this.seq);
    }

    public void add(DERObjectIdentifier oid, String value) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)oid);
        v.add((DEREncodable)new DERPrintableString(value));
        this.add((ASN1Set)new DERSet((DEREncodable)new DERSequence(v)));
    }

    public void add(ASN1Set entry) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        int size = this.seq.size();
        int i = 0;
        while (i < size) {
            v.add(this.seq.getObjectAt(i));
            ++i;
        }
        v.add((DEREncodable)entry);
        this.seq = new DERSequence(v);
    }

    public ASN1Set getNameEntryAt(int i) {
        return (ASN1Set)this.seq.getObjectAt(i);
    }

    public ASN1Set getLastNameEntry() {
        int size = this.seq.size();
        return size > 0 ? this.getNameEntryAt(size - 1) : null;
    }

    public static ASN1Set getLastNameEntry(X509Name name) {
        ASN1Sequence seq = (ASN1Sequence)name.getDERObject();
        int size = seq.size();
        return size > 0 ? (ASN1Set)seq.getObjectAt(size - 1) : null;
    }

    public static String toString(X509Name name) {
        if (name == null) {
            return null;
        }
        return X509NameHelper.toString((ASN1Sequence)name.getDERObject());
    }

    private static String toString(ASN1Sequence seq) {
        if (seq == null) {
            return null;
        }
        Enumeration e = seq.getObjects();
        StringBuffer buf = new StringBuffer();
        while (e.hasMoreElements()) {
            ASN1Set set = (ASN1Set)e.nextElement();
            Enumeration ee = set.getObjects();
            buf.append('/');
            while (ee.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)ee.nextElement();
                DERObjectIdentifier oid = (DERObjectIdentifier)s.getObjectAt(0);
                String sym = (String)X509Name.OIDLookUp.get(oid);
                if (sym == null) {
                    buf.append(oid.getId());
                } else {
                    buf.append(sym);
                }
                buf.append('=');
                buf.append(((DERString)s.getObjectAt(1)).getString());
                if (!ee.hasMoreElements()) continue;
                buf.append('+');
            }
        }
        return buf.toString();
    }

    public String toString() {
        return X509NameHelper.toString(this.seq);
    }
}

