/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.SigningPolicy;
import org.globus.gsi.SigningPolicyParserException;
import org.globus.util.I18n;

public class SigningPolicyParser {
    private static I18n i18n = I18n.getI18n("org.globus.gsi.errors", SigningPolicyParser.class.getClassLoader());
    private static Log logger = LogFactory.getLog((String)SigningPolicyParser.class.getName());
    public static String ACCESS_ID_PREFIX = "access_id_";
    public static String ACCESS_ID_CA = "access_id_CA";
    public static String DEF_AUTH_X509 = "X509";
    public static String DEF_AUTH_GLOBUS = "globus";
    public static String POS_RIGHTS = "pos_rights";
    public static String NEG_RIGHTS = "neg_rights";
    public static String CONDITION_PREFIX = "cond_";
    public static String CONDITION_SUBJECT = "cond_subjects";
    public static String VALUE_CA_SIGN = "CA:sign";
    public static String SINGLE_CHAR = "?";
    public static String WILDCARD = "*";
    public static String SINGLE_PATTERN = "[\\p{Print}\\p{Blank}]";
    public static String WILDCARD_PATTERN = String.valueOf(SINGLE_PATTERN) + "*";
    private static final char[] EMAIL_KEYWORD_1 = new char[]{'E', '='};
    private static final char[] EMAIL_KEYWORD_2 = new char[]{'E', 'm', 'a', 'i', 'l', '='};
    private static final String EMAIL_KEYWORD = "emailAddress=";

    public static SigningPolicy getPolicy(String fileName, String requiredCaDN) throws SigningPolicyParserException {
        if (fileName == null || fileName.trim().equals("")) {
            throw new IllegalArgumentException();
        }
        logger.debug((Object)("Signing policy file name " + fileName + " with CA DN " + requiredCaDN));
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(fileName);
        }
        catch (FileNotFoundException exp) {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new SigningPolicyParserException(exp.getMessage(), exp);
        }
        SigningPolicy policy = SigningPolicyParser.getPolicy(fileReader, requiredCaDN);
        policy.setFileName(fileName);
        logger.debug((Object)("Policy file parsing completed, policy is " + (policy == null)));
        return policy;
    }

    /*
     * Exception decompiling
     */
    public static SigningPolicy getPolicy(Reader reader, String requiredCaDN) throws SigningPolicyParserException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[WHILELOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isValidLine(String line) throws SigningPolicyParserException {
        if ((line = line.trim()).equals("") || line.startsWith("#")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (tokenizer.countTokens() < 3) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private static Vector getAllowedDNs(String line, String lineForErr) throws SigningPolicyParserException {
        block6: {
            block7: {
                index = SigningPolicyParser.findIndex(line = line.trim());
                if (index == -1) {
                    err = SigningPolicyParser.i18n.getMessage("invalidTokens", line);
                    throw new SigningPolicyParserException(err);
                }
                defAuth = line.substring(0, index);
                if (!SigningPolicyParser.DEF_AUTH_GLOBUS.equals(defAuth)) break block6;
                value = line.substring(index + 1, line.length());
                value = value.trim();
                startIndex = 0;
                endIndex = value.length();
                if (value.charAt(startIndex) == '\'') {
                    if ((endOfDNIndex = value.indexOf(39, ++startIndex)) == -1) {
                        err = SigningPolicyParser.i18n.getMessage("invalidSubjects", lineForErr);
                        throw new SigningPolicyParserException(err);
                    }
                    endIndex = endOfDNIndex;
                }
                value = value.substring(startIndex, endIndex);
                if ((value = value.trim()).equals("")) {
                    err = SigningPolicyParser.i18n.getMessage("emptySubjects", lineForErr);
                    throw new SigningPolicyParserException(err);
                }
                vector = new Vector<Pattern>();
                startIndex = 0;
                endIndex = value.length();
                if (value.indexOf("\"") != -1) ** GOTO lbl36
                vector.add(SigningPolicyParser.getPattern(value));
                break block7;
lbl-1000:
                // 1 sources

                {
                    quot1 = value.indexOf("\"", startIndex);
                    quot2 = value.indexOf("\"", quot1 + 1);
                    if (quot2 == -1) {
                        err = SigningPolicyParser.i18n.getMessage("unmatchedQuotes", lineForErr);
                        throw new SigningPolicyParserException(err);
                    }
                    token = value.substring(quot1 + 1, quot2);
                    vector.add(SigningPolicyParser.getPattern(token));
                    startIndex = quot2 + 1;
lbl36:
                    // 2 sources

                    ** while (startIndex < endIndex)
                }
            }
            return vector;
        }
        return null;
    }

    private static boolean isCASignRight(String line) throws SigningPolicyParserException {
        int index = SigningPolicyParser.findIndex(line = line.trim());
        if (index == -1) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        String def_auth = line.substring(0, index);
        if (DEF_AUTH_GLOBUS.equals(def_auth)) {
            line = line.substring(index + 1, line.length());
            String value = (line = line.trim()).substring(0, line.length());
            if (VALUE_CA_SIGN.equals(value)) {
                return true;
            }
        }
        return false;
    }

    private static String getCA(String inputLine) throws SigningPolicyParserException {
        String line = inputLine.trim();
        int index = SigningPolicyParser.findIndex(line);
        if (index == -1) {
            String err = i18n.getMessage("invalidTokens", line);
            throw new SigningPolicyParserException(err);
        }
        String defAuth = line.substring(0, index);
        if (DEF_AUTH_X509.equals(defAuth)) {
            line = line.substring(index + 1, line.length());
            line = line.trim();
            String dnString = line.substring(0, line.length());
            String caDN = null;
            int caDNLocation = 0;
            if (line.charAt(caDNLocation) == '\'') {
                int endofDNIndex;
                if ((endofDNIndex = line.indexOf(39, ++caDNLocation + 1)) == -1) {
                    String err = i18n.getMessage("invalidCaDN", inputLine);
                    throw new SigningPolicyParserException(err);
                }
                caDN = line.substring(caDNLocation, endofDNIndex);
            } else {
                caDN = line.substring(caDNLocation, line.length() - 1);
            }
            caDN = caDN.trim();
            return caDN;
        }
        return null;
    }

    public static Pattern getPattern(String patternStr) {
        String preStr;
        if (patternStr == null) {
            throw new IllegalArgumentException();
        }
        int startIndex = 0;
        int endIndex = patternStr.length();
        StringBuffer buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            int star = patternStr.indexOf(WILDCARD, startIndex);
            if (star == -1) {
                star = endIndex;
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr);
            } else {
                preStr = patternStr.substring(startIndex, star);
                buffer = buffer.append(preStr).append(WILDCARD_PATTERN);
            }
            startIndex = star + 1;
        }
        patternStr = buffer.toString();
        startIndex = 0;
        endIndex = patternStr.length();
        buffer = new StringBuffer("");
        while (startIndex < endIndex) {
            int qMark = patternStr.indexOf(SINGLE_CHAR, startIndex);
            if (qMark == -1) {
                qMark = endIndex;
                preStr = patternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr);
            } else {
                preStr = patternStr.substring(startIndex, qMark);
                buffer = buffer.append(preStr).append(SINGLE_PATTERN);
            }
            startIndex = qMark + 1;
        }
        patternStr = buffer.toString();
        logger.debug((Object)("String with replaced pattern is " + patternStr));
        return Pattern.compile(patternStr, 2);
    }

    private static int findIndex(String line) {
        int index = -1;
        if (line == null) {
            return index;
        }
        line = line.trim();
        int spaceIndex = line.indexOf(" ");
        int tabIndex = line.indexOf("\t");
        index = spaceIndex != -1 ? (tabIndex != -1 ? (spaceIndex < tabIndex ? spaceIndex : tabIndex) : spaceIndex) : tabIndex;
        return index;
    }

    public static boolean equalsDN(String dn1, String dn2) {
        if (dn1 == null && dn2 == null) {
            return true;
        }
        if (dn1 == null || dn2 == null) {
            return false;
        }
        return SigningPolicyParser.normalizeDN(dn1).equals(SigningPolicyParser.normalizeDN(dn2));
    }

    private static boolean keyWordPresent(char[] args, int startIndex, char[] keyword) {
        if (startIndex + keyword.length > args.length) {
            return false;
        }
        int i = 0;
        int j = startIndex;
        while (i < keyword.length) {
            if (args[j] != keyword[i]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    public static String normalizeDN(String globusID) {
        if (globusID == null) {
            return null;
        }
        char[] globusIdChars = globusID.toCharArray();
        StringBuffer normalizedDN = new StringBuffer(globusIdChars.length);
        int i = 0;
        while (i < globusIdChars.length) {
            if (globusIdChars[i] == '/') {
                normalizedDN.append("/");
                if (SigningPolicyParser.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_1)) {
                    normalizedDN.append(EMAIL_KEYWORD);
                    i += EMAIL_KEYWORD_1.length;
                } else if (SigningPolicyParser.keyWordPresent(globusIdChars, i + 1, EMAIL_KEYWORD_2)) {
                    normalizedDN.append(EMAIL_KEYWORD);
                    i += EMAIL_KEYWORD_2.length;
                }
            } else {
                normalizedDN.append(globusIdChars[i]);
            }
            ++i;
        }
        return normalizedDN.toString();
    }
}

