/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.exception.FTPReplyParseException;

public class Reply
implements Serializable {
    private static Log logger = LogFactory.getLog((String)Reply.class.getName());
    public static final int POSITIVE_PRELIMINARY = 1;
    public static final int POSITIVE_COMPLETION = 2;
    public static final int POSITIVE_INTERMEDIATE = 3;
    public static final int TRANSIENT_NEGATIVE_COMPLETION = 4;
    public static final int PERMANENT_NEGATIVE_COMPLETION = 5;
    private static final int MIN_FIRST_LEN = 4;
    protected String message;
    protected int code;
    protected int category;
    protected boolean isMultiline;

    protected Reply() {
    }

    public Reply(BufferedReader input) throws FTPReplyParseException, EOFException, IOException {
        logger.debug((Object)"read 1st line");
        String line = input.readLine();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("1st line: " + line));
        }
        if (line == null) {
            throw new EOFException();
        }
        if ((line = Reply.ignoreLeading0(line)).length() < 4) {
            throw new FTPReplyParseException(1, "Minimum 1st line length = 4. Here's the incorrect 1st line ->" + line + "<-");
        }
        String codeString = line.substring(0, 3);
        try {
            this.code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException e) {
            throw new FTPReplyParseException(2, "Here's the incorrect line ->" + line + "<-" + "and the first 3 chars ->" + codeString + "<-");
        }
        this.category = line.charAt(0) - 48;
        char char4 = line.charAt(3);
        this.message = line.substring(4, line.length());
        if (char4 == ' ') {
            this.isMultiline = false;
        } else if (char4 == '-') {
            this.isMultiline = true;
            String lastLineStarts = String.valueOf(codeString) + ' ';
            String lineSeparator = System.getProperty("line.separator");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("multiline reply; last line should start with ->" + lastLineStarts + "<-"));
                logger.debug((Object)("lenght of line.separator on this OS: " + lineSeparator.length()));
            }
            StringBuffer buf = new StringBuffer(this.message);
            do {
                logger.debug((Object)"read line");
                line = input.readLine();
                if (line == null) {
                    throw new EOFException();
                }
                line = Reply.ignoreLeading0(line);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("line : ->" + line + "<-"));
                }
                buf.append(lineSeparator).append(line);
            } while (!line.startsWith(lastLineStarts));
            logger.debug((Object)"end reached");
            this.message = buf.toString();
        } else {
            throw new FTPReplyParseException(3, "Here's the incorrect line ->" + line + "<-");
        }
    }

    public int getCategory() {
        return this.category;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public String getMessage() {
        return this.message;
    }

    public static boolean isPositivePreliminary(Reply reply) {
        return reply.getCategory() == 1;
    }

    public static boolean isPositiveCompletion(Reply reply) {
        return reply.getCategory() == 2;
    }

    public static boolean isPositiveIntermediate(Reply reply) {
        return reply.getCategory() == 3;
    }

    public static boolean isTransientNegativeCompletion(Reply reply) {
        return reply.getCategory() == 4;
    }

    public static boolean isPermanentNegativeCompletion(Reply reply) {
        return reply.getCategory() == 5;
    }

    public String toString() {
        String mult = this.isMultiline ? "-" : " ";
        return String.valueOf(this.code) + mult + this.message;
    }

    protected static String ignoreLeading0(String line) {
        if (line.length() > 0 && line.charAt(0) == '\u0000') {
            logger.debug((Object)"WARNING: The first character of the reply is 0. Ignoring the character.");
            return line.substring(1, line.length());
        }
        return line;
    }
}

