/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPort6;
import org.globus.ftp.Options;
import org.globus.ftp.Session;
import org.globus.ftp.dc.ActiveConnectTask;
import org.globus.ftp.dc.DataChannelFactory;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.PassiveConnectTask;
import org.globus.ftp.dc.SimpleDataChannelFactory;
import org.globus.ftp.dc.SimpleTransferContext;
import org.globus.ftp.dc.Task;
import org.globus.ftp.dc.TaskThread;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPControlChannel;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;
import org.globus.net.ServerSocketFactory;
import org.globus.net.SocketFactory;
import org.globus.util.Util;

public class FTPServerFacade {
    private static Log logger = LogFactory.getLog((String)FTPServerFacade.class.getName());
    public static final int ANY_PORT = 0;
    public static final int DEFAULT_QUEUE = 100;
    protected Session session;
    protected LocalControlChannel localControlChannel;
    protected DataChannelFactory dataChannelFactory;
    protected ServerSocket serverSocket;
    protected FTPControlChannel remoteControlChannel;
    protected HostPort remoteServerAddress;
    private TaskThread taskThread;

    public static void cannotPropagateError(Throwable e) {
        logger.error((Object)"Exception occured in the exception handling code, so it cannot be properly propagated to the user", e);
    }

    public FTPServerFacade(FTPControlChannel remoteControlChannel) {
        this.remoteControlChannel = remoteControlChannel;
        this.session = new Session();
        this.localControlChannel = new LocalControlChannel();
        this.dataChannelFactory = new SimpleDataChannelFactory();
    }

    public BasicClientControlChannel getControlChannel() {
        return this.localControlChannel;
    }

    public Session getSession() {
        return this.session;
    }

    public void authorize() {
        this.session.authorized = true;
    }

    public void setTransferType(int type) {
        this.session.transferType = type;
    }

    public void setTransferMode(int mode) {
        this.session.transferMode = mode;
    }

    public void setProtectionBufferSize(int size) {
        this.session.protectionBufferSize = size;
    }

    public void setOptions(Options opts) {
    }

    public HostPort setPassive() throws IOException {
        return this.setPassive(0, 100);
    }

    public HostPort setPassive(int port, int queue) throws IOException {
        if (this.serverSocket == null) {
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            this.serverSocket = factory.createServerSocket(port, queue);
        }
        this.session.serverMode = 1;
        String address = Util.getLocalHostAddress();
        int localPort = this.serverSocket.getLocalPort();
        if (this.remoteControlChannel.isIPv6()) {
            String version = HostPort6.getIPAddressVersion(address);
            this.session.serverAddress = new HostPort6(version, address, localPort);
        } else {
            this.session.serverAddress = new HostPort(address, localPort);
        }
        logger.debug((Object)("started passive server at port " + this.session.serverAddress.getPort()));
        return this.session.serverAddress;
    }

    public void setActive(HostPort hp) throws UnknownHostException, ClientException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("hostport: " + hp.getHost() + " " + hp.getPort()));
        }
        this.session.serverMode = 2;
        this.remoteServerAddress = hp;
    }

    protected void exceptionToControlChannel(Throwable e, String msg) {
        FTPServerFacade.exceptionToControlChannel(e, msg, this.localControlChannel);
    }

    public static void exceptionToControlChannel(Throwable e, String msg, BasicServerControlChannel control) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String stack = writer.toString();
        LocalReply reply = new LocalReply(451, String.valueOf(msg) + "\n" + e.toString() + "\n" + stack);
        control.write(reply);
    }

    public void store(DataSink sink) {
        try {
            this.localControlChannel.resetReplyCount();
            TransferContext context = this.createTransferContext();
            if (this.session.serverMode == 1) {
                this.runTask(this.createPassiveConnectTask(sink, context));
            } else {
                this.runTask(this.createActiveConnectTask(sink, context));
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during store()");
        }
    }

    public void retrieve(DataSource source) {
        try {
            this.localControlChannel.resetReplyCount();
            TransferContext context = this.createTransferContext();
            if (this.session.serverMode == 1) {
                this.runTask(this.createPassiveConnectTask(source, context));
            } else {
                this.runTask(this.createActiveConnectTask(source, context));
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during retrieve()");
        }
    }

    public void abort() throws IOException {
    }

    protected void transferAbort() {
        if (this.session.serverMode == 1) {
            this.unblockServer();
            this.stopTaskThread();
        }
    }

    protected void unblockServer() {
        block13: {
            if (this.serverSocket == null) {
                return;
            }
            String address = Util.getLocalHostAddress();
            int port = this.serverSocket.getLocalPort();
            SocketFactory factory = SocketFactory.getDefault();
            Socket s = null;
            try {
                try {
                    s = factory.createSocket(address, port);
                    s.getInputStream();
                }
                catch (Exception exception) {
                    if (s == null) break block13;
                    try {
                        s.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void close() throws IOException {
        logger.debug((Object)"close data channels");
        this.abort();
        logger.debug((Object)"close server socket");
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.unblockServer();
        }
        this.stopTaskThread();
    }

    private void runTask(Task task) {
        if (this.taskThread == null) {
            this.taskThread = new TaskThread();
        }
        this.taskThread.runTask(task);
    }

    protected void stopTaskThread() {
        logger.debug((Object)"stop master thread");
        if (this.taskThread != null) {
            this.taskThread.stop();
            this.taskThread.join();
            this.taskThread = null;
        }
    }

    private PassiveConnectTask createPassiveConnectTask(DataSource source, TransferContext context) {
        return new PassiveConnectTask(this.serverSocket, source, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    private PassiveConnectTask createPassiveConnectTask(DataSink sink, TransferContext context) {
        return new PassiveConnectTask(this.serverSocket, sink, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    private ActiveConnectTask createActiveConnectTask(DataSource source, TransferContext context) {
        return new ActiveConnectTask(this.remoteServerAddress, source, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    private ActiveConnectTask createActiveConnectTask(DataSink sink, TransferContext context) {
        return new ActiveConnectTask(this.remoteServerAddress, sink, (BasicServerControlChannel)this.localControlChannel, this.session, this.dataChannelFactory, context);
    }

    protected TransferContext createTransferContext() {
        return SimpleTransferContext.getDefault();
    }

    protected class LocalControlChannel
    extends BasicClientControlChannel
    implements BasicServerControlChannel {
        private LinkedList replies = new LinkedList();
        private int replyCount = 0;

        protected synchronized void push(Reply newReply) {
            this.replies.add(newReply);
            ++this.replyCount;
            this.notify();
        }

        protected synchronized Reply pop() throws InterruptedException {
            while (this.replies.isEmpty()) {
                this.wait();
            }
            return (Reply)this.replies.removeFirst();
        }

        public synchronized boolean ready() {
            return !this.replies.isEmpty();
        }

        @Override
        public synchronized int getReplyCount() {
            return this.replyCount;
        }

        @Override
        public synchronized void resetReplyCount() {
            this.replies.clear();
            this.replyCount = 0;
        }

        @Override
        public Reply read() throws IOException, FTPReplyParseException, ServerException {
            try {
                return this.pop();
            }
            catch (InterruptedException e) {
                ServerException se = new ServerException(0, "interrupted while waiting.");
                se.setRootCause(e);
                throw se;
            }
        }

        @Override
        public void write(Reply reply) {
            this.push(reply);
        }

        @Override
        public void waitFor(Flag aborted, int ioDelay, int maxWait) throws ServerException, IOException, InterruptedException {
            int i = 0;
            logger.debug((Object)"waiting for reply in local control channel");
            while (!this.ready()) {
                if (aborted.flag) {
                    throw new InterruptedException();
                }
                logger.debug((Object)("slept " + i));
                Thread.sleep(ioDelay);
                if (maxWait == -1 || (i += ioDelay) < maxWait) continue;
                logger.debug((Object)"timeout");
                throw new ServerException(4);
            }
            logger.debug((Object)"local control channel ready");
        }

        @Override
        public void abortTransfer() {
            FTPServerFacade.this.transferAbort();
        }
    }
}

