/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPort6;

public class HostPortList {
    private String sporCommandParam;
    private Vector vector = null;

    public HostPortList(String spasReplyMsg) {
        try {
            this.parseFormat(spasReplyMsg, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public HostPortList() {
    }

    public void add(HostPort hp) {
        if (this.vector == null) {
            this.vector = new Vector();
        }
        this.vector.add(hp);
        this.sporCommandParam = null;
    }

    public int size() {
        return this.vector == null ? 0 : this.vector.size();
    }

    public HostPort get(int index) {
        return this.vector == null ? null : (HostPort)this.vector.elementAt(index);
    }

    public String toFtpCmdArgument() {
        if (this.sporCommandParam == null && this.vector != null) {
            StringBuffer cmd = new StringBuffer();
            int i = 0;
            while (i < this.vector.size()) {
                HostPort hp = (HostPort)this.vector.get(i);
                if (i != 0) {
                    cmd.append(' ');
                }
                cmd.append(hp.toFtpCmdArgument());
                ++i;
            }
            this.sporCommandParam = cmd.toString();
        }
        return this.sporCommandParam;
    }

    private void parseFormat(String msg, boolean ipv6) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(msg));
        StringBuffer command = null;
        String line = null;
        line = reader.readLine();
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith(" ")) {
                if (line.startsWith("229")) break;
                throw new IllegalArgumentException("Not a proper reply message ->" + line + "<-");
            }
            if ((line = line.trim()).startsWith("229")) break;
            if (this.vector == null) {
                this.vector = new Vector();
            }
            if (ipv6) {
                this.vector.add(new HostPort6(line));
            } else {
                this.vector.add(new HostPort(line));
            }
            if (command == null) {
                command = new StringBuffer();
            } else {
                command.append(' ');
            }
            command.append(line);
        }
        if (this.vector == null) {
            throw new IllegalArgumentException("Not a proper reply message ->" + line + "<-");
        }
        this.sporCommandParam = command.toString();
    }

    public static HostPortList parseIPv6Format(String message) {
        HostPortList list = new HostPortList();
        try {
            list.parseFormat(message, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static HostPortList parseIPv4Format(String message) {
        HostPortList list = new HostPortList();
        try {
            list.parseFormat(message, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }
}

