/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp;

import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.ByteRange;
import org.globus.ftp.RestartData;

public class ByteRangeList
implements RestartData {
    private static Log logger = LogFactory.getLog((String)ByteRangeList.class.getName());
    protected Vector vector = new Vector();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ByteRangeList) {
            ByteRangeList otherObj = (ByteRangeList)other;
            if (this.vector.size() != otherObj.vector.size()) {
                return false;
            }
            int i = 0;
            while (i < this.vector.size()) {
                if (!this.vector.elementAt(i).equals(otherObj.vector.elementAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int value = 0;
        int i = 0;
        while (i < this.vector.size()) {
            value += this.vector.elementAt(i).hashCode();
            ++i;
        }
        return value;
    }

    public void merge(ByteRange range) {
        ByteRange newRange = new ByteRange(range);
        logger.debug((Object)(String.valueOf(this.toFtpCmdArgument()) + " + " + newRange.toString()));
        int oldSize = this.vector.size();
        int index = 0;
        int NOT_YET = -1;
        int merged = -1;
        if (oldSize == 0) {
            this.vector.add(newRange);
            return;
        }
        int i = 0;
        while (i < oldSize) {
            int result = newRange.merge((ByteRange)this.vector.elementAt(index));
            switch (result) {
                case 5: {
                    ++index;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    if (merged == -1) {
                        this.vector.remove(index);
                        this.vector.add(index, newRange);
                        merged = index++;
                        break;
                    }
                    this.vector.remove(index);
                    break;
                }
                case 1: {
                    if (merged == -1) {
                        this.vector.add(index, newRange);
                    }
                    return;
                }
            }
            ++i;
        }
        if (merged == -1) {
            this.vector.add(newRange);
        }
    }

    public void merge(Vector other) {
        int i = 0;
        while (i < other.size()) {
            this.merge((ByteRange)other.elementAt(i));
            ++i;
        }
    }

    public void merge(ByteRangeList other) {
        this.merge(other.vector);
    }

    public Vector toVector() {
        return this.vector;
    }

    @Override
    public String toFtpCmdArgument() {
        char comma = ',';
        boolean first = true;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.vector.size()) {
            if (first) {
                first = false;
            } else {
                result.append(comma);
            }
            result.append(this.vector.elementAt(i).toString());
            ++i;
        }
        return result.toString();
    }
}

