/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.sensors;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.cisprovider.impl.UrlExtractor;
import de.fzj.unicore.cisprovider.xmlbeans.SiteDocument;
import de.fzj.unicore.wsrflite.Kernel;
import org.apache.xmlbeans.XmlObject;

public class SiteInfo
extends DefaultSensor {
    @Override
    public String getName() {
        return "SiteInfo";
    }

    public SiteInfo(Kernel kernel) {
        super(kernel);
        this.setLastEvent(this.createEvent());
    }

    protected DefaultMonitoringEvent createEvent() {
        DefaultMonitoringEvent e = new DefaultMonitoringEvent();
        e.setDescription("This contains general information about the site");
        e.setTopic("/Site/General");
        e.setTitle("Site information");
        e.setDetails((XmlObject)this.makeDetailedSiteInfo());
        if (this.getLastEvent() != null) {
            e.setSupersedes(this.getLastEvent().getID());
        }
        return e;
    }

    protected SiteDocument makeDetailedSiteInfo() {
        SiteDocument sd = SiteDocument.Factory.newInstance();
        SiteDocument.Site s = sd.addNewSite();
        CIPProperties cfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
        s.addNewGeoData().setLatitude(cfg.getValue("site.latitude"));
        s.getGeoData().setLongitude(cfg.getValue("site.longitude"));
        String baseUrl = this.kernel.getContainerProperties().getBaseUrl();
        String serviceUrl = baseUrl + "/TargetSystemFactory";
        String name = cfg.getValue("site.name");
        if (name == null) {
            name = UrlExtractor.generateSiteName(baseUrl);
        }
        s.setName(name);
        String url = cfg.getValue("site.url");
        if (url == null) {
            url = serviceUrl;
        }
        s.setURL(url);
        s.setNumberOfCPUs(cfg.getIntValue("site.cpus").intValue());
        s.setDescription(cfg.getValue("site.description"));
        return sd;
    }
}

