/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.sensors;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.cisprovider.xmlbeans.JobsDocument;
import de.fzj.unicore.uas.xnjs.XNJSFacade;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.xnjs.tsi.IExecutionSystemInformation;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import org.apache.xmlbeans.XmlObject;

public class JobInfo
extends DefaultSensor {
    private volatile int totalJobs;
    private volatile int runningJobs;
    private volatile int waitingJobs;
    private boolean dirty;
    public static int DEFAULT_NOTIFICATION = 10;

    @Override
    public String getName() {
        return "Jobs";
    }

    @Override
    protected void setLastEvent(MonitoringEvent e) {
        this.dirty = true;
        super.setLastEvent(e);
    }

    @Override
    protected void doNotify() {
        if (this.dirty) {
            this.dirty = false;
            super.doNotify();
        }
    }

    public JobInfo(Kernel kernel) {
        this(kernel, DEFAULT_NOTIFICATION);
    }

    public JobInfo(Kernel kernel, int interval) {
        super(kernel);
        this.setLastEvent(this.createEvent());
        Runnable command = new Runnable(){

            @Override
            public void run() {
                JobInfo.this.update();
            }
        };
        kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().scheduleWithFixedDelay(command, 10L, 10L, TimeUnit.SECONDS);
    }

    private void update() {
        IExecutionSystemInformation sysInfo = (IExecutionSystemInformation)XNJSFacade.get(null, (Kernel)this.kernel).getConfiguration().getComponentInstanceOfType(IExecutionSystemInformation.class);
        this.totalJobs = sysInfo.getTotalNumberOfJobs();
        this.runningJobs = sysInfo.getNumberOfRunningJobs();
        this.waitingJobs = sysInfo.getNumberOfQueuedJobs();
        this.setLastEvent(this.createEvent());
        this.doNotify();
    }

    protected DefaultMonitoringEvent createEvent() {
        DefaultMonitoringEvent e = new DefaultMonitoringEvent();
        e.setDescription("This contains information about the jobs on the site");
        e.setTopic("/Jobs/General");
        e.setTitle("Job information");
        e.setDetails((XmlObject)this.makeDetailedJobInfo());
        if (this.getLastEvent() != null) {
            e.setSupersedes(this.getLastEvent().getID());
        }
        return e;
    }

    protected JobsDocument makeDetailedJobInfo() {
        JobsDocument jd = JobsDocument.Factory.newInstance();
        JobsDocument.Jobs j = jd.addNewJobs();
        j.setTotalJobs(BigInteger.valueOf(this.totalJobs));
        j.setRunningJobs(BigInteger.valueOf(this.runningJobs));
        j.setWaitingJobs(BigInteger.valueOf(this.waitingJobs));
        return jd;
    }
}

