/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.sensors;

import de.fzj.unicore.cisprovider.impl.DefaultMonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultSensor;
import de.fzj.unicore.wsrflite.Kernel;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;

public class Heartbeat
extends DefaultSensor
implements Runnable {
    private static final Logger logger = Logger.getLogger((String)("unicore.services.cip" + Heartbeat.class.getSimpleName()));
    private static final int DEFAULT_INTERVAL = 300;
    private Calendar upSince;
    private int interval;

    public Heartbeat(Kernel kernel) {
        this(kernel, 300);
    }

    public Heartbeat(Kernel kernel, int interval) {
        super(kernel);
        this.interval = interval;
        this.init();
    }

    protected void init() {
        this.upSince = Calendar.getInstance();
        this.kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().scheduleWithFixedDelay(this, this.interval, this.interval, TimeUnit.SECONDS);
        logger.info((Object)("Configured heartbeat at interval of " + this.interval + " seconds."));
        this.setLastEvent(this.createEvent());
    }

    protected XmlString getUpSince() {
        XmlString s = XmlString.Factory.newInstance();
        s.setStringValue(this.upSince.getTime().toString());
        return s;
    }

    protected DefaultMonitoringEvent createEvent() {
        DefaultMonitoringEvent e = new DefaultMonitoringEvent();
        e.setDescription("This periodic heartbeat event is published every [" + this.interval + "] second(s).");
        e.setDetails((XmlObject)this.getUpSince());
        e.setTopic("/Site/Heartbeat");
        e.setTitle("Heartbeat event");
        if (this.getLastEvent() != null) {
            e.setSupersedes(this.getLastEvent().getID());
        }
        return e;
    }

    @Override
    public String getName() {
        return "Heartbeat";
    }

    @Override
    public void run() {
        DefaultMonitoringEvent e = this.createEvent();
        this.setLastEvent(e);
        this.doNotify();
    }
}

