/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlExtractor {
    private static String UrlRe = "://(\\S+):(\\d+)/([^/]*)";

    public static Map<String, String> extractUrl(String url) {
        HashMap<String, String> extractedMap = new HashMap<String, String>();
        Pattern p = Pattern.compile(UrlRe, 2);
        Matcher m = p.matcher(url);
        while (m.find()) {
            extractedMap.put("cip.hostname", m.group(1));
            extractedMap.put("cip.port", m.group(2));
            if (!m.group(3).contains("services")) {
                extractedMap.put("cip.sitename", m.group(3));
                continue;
            }
            extractedMap.put("cip.sitename", "DEFAULT-SITE");
        }
        return extractedMap;
    }

    public static String generateUniqueSiteName(Map<String, String> map) {
        String str = "";
        for (String s : map.values()) {
            str = str + s + ".";
        }
        return str.substring(0, str.lastIndexOf(46));
    }

    public static String generateUniqueSiteName(String url) {
        Map<String, String> map = UrlExtractor.extractUrl(url);
        String str = map.get("cip.hostname") + "$" + map.get("cip.port") + "$" + map.get("cip.sitename");
        return str;
    }

    public static String generateSiteName(String url) {
        Map<String, String> map = UrlExtractor.extractUrl(url);
        String str = map.get("cip.sitename") + " at " + map.get("cip.hostname") + ":" + map.get("cip.port");
        return str;
    }
}

