/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.impl.CISInfoProviderImpl;
import de.fzj.unicore.cisprovider.impl.GlueInstanceGenerator;
import de.fzj.unicore.cisprovider.sensors.ApplicationsInfo;
import de.fzj.unicore.cisprovider.sensors.ExecutionEnvironmentInfo;
import de.fzj.unicore.cisprovider.sensors.JobInfo;
import de.fzj.unicore.cisprovider.sensors.SiteInfo;
import de.fzj.unicore.cisprovider.sensors.TextInfo;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.ContainerProperties;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.security.IContainerSecurityConfiguration;
import de.fzj.unicore.wsrflite.utils.WSServerUtilities;
import de.fzj.unicore.wsrflite.xfire.XFireKernel;
import de.fzj.unicore.wsrflite.xmlbeans.registry.RegistryHandler;
import eu.unicore.util.configuration.UpdateableConfiguration;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class InitOnStartup
implements Runnable {
    private final Kernel kernel;

    public InitOnStartup(Kernel kernel) {
        this.kernel = kernel;
    }

    @Override
    public void run() {
        CIPProperties cipCfg = new CIPProperties(this.kernel.getContainerProperties().getRawProperties());
        this.kernel.addConfigurationHandler(CIPProperties.class, (UpdateableConfiguration)cipCfg);
        Monitor m = cipCfg.getMonitor();
        m.addSensor(new SiteInfo(this.kernel));
        m.addSensor(new JobInfo(this.kernel));
        m.addSensor(new ApplicationsInfo(this.kernel));
        m.addSensor(new ExecutionEnvironmentInfo(this.kernel));
        m.addSensor(new TextInfo(this.kernel));
        this.initGlue2Generator();
        if (!this.cipAvailable()) {
            CISInfoProviderImpl.logger.warn((Object)"CIS Infoprovider is not deployed, not publishing service info to the registry");
            return;
        }
        this.publish();
    }

    protected boolean cipAvailable() {
        return XFireKernel.get((Kernel)this.kernel).getService("CISInfoProvider") != null;
    }

    protected void publish() {
        try {
            CIPProperties cfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
            if (!cfg.getBooleanValue("publish").booleanValue()) {
                CISInfoProviderImpl.logger.info((Object)"NOT publishing CIP to registry.");
                return;
            }
            EndpointReferenceType epr = WSServerUtilities.newEPR((IContainerSecurityConfiguration)this.kernel.getContainerSecurityConfiguration());
            epr.addNewAddress().setStringValue(WSServerUtilities.makeAddress((String)"CISInfoProvider", (ContainerProperties)this.kernel.getContainerProperties()));
            WSServerUtilities.addPortType((EndpointReferenceType)epr, (QName)CISInfoProvider.PORTTYPE);
            RegistryHandler rh = (RegistryHandler)this.kernel.getAttribute(RegistryHandler.class);
            rh.getRegistryClient().addRegistryEntry(epr);
            CISInfoProviderImpl.logger.info((Object)"Added registry entry for CISInfoProvider");
        }
        catch (Exception e) {
            LogUtil.logException((String)"Could not publish to registry", (Throwable)e, (Logger)CISInfoProviderImpl.logger);
        }
    }

    protected void initGlue2Generator() {
        CIPProperties cipCfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
        boolean enabled = cipCfg.getBooleanValue("glue2.generate");
        if (enabled) {
            String path = cipCfg.getValue("glue2.targetPath");
            long period = cipCfg.getLongValue("glue2.refreshPeriod");
            Glue2Generate command = new Glue2Generate(this.kernel);
            this.kernel.getContainerProperties().getThreadingServices().getScheduledExecutorService().scheduleWithFixedDelay(command, 5L, period, TimeUnit.SECONDS);
            CISInfoProviderImpl.logger.info((Object)("Generating GLUE2 service description at <" + path + "> every " + period + " seconds."));
        }
    }

    public static class Glue2Generate
    implements Runnable {
        final Kernel kernel;

        public Glue2Generate(Kernel kernel) {
            this.kernel = kernel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                CIPProperties cfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
                String path = cfg.getValue("glue2.targetPath");
                FileOutputStream fos = new FileOutputStream(path);
                String unique = this.kernel.getContainerProperties().getBaseUrl();
                try {
                    new GlueInstanceGenerator().generate(cfg, unique).save((OutputStream)fos);
                }
                finally {
                    fos.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

