/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.util.DateUtil;
import de.fzj.unicore.cisprovider.xmlbeans.JobsDocument;
import de.fzj.unicore.cisprovider.xmlbeans.SiteDocument;
import de.fzj.unicore.uas.util.LogUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;
import org.json.JSONException;
import org.json.JSONObject;
import org.ogf.schemas.glue.x2009.x03.spec20R1.AdminDomainT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ApplicationEnvironmentsDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingEndpointT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingManagerT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ComputingServiceT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.EndpointHealthStateT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ExecutionEnvironmentT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ExtendedBooleanT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ExtensionT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ExtensionsT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.LocationT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.QualityLevelT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServingStateT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.StorageServiceCapacityT;
import org.ogf.schemas.glue.x2009.x03.spec20R1.StorageServiceT;
import org.unigrids.services.atomic.types.TextInfoType;

public class GlueInstanceGenerator {
    private static final Logger logger = LogUtil.getLogger((String)"unicore.services.cip", GlueInstanceGenerator.class);
    private DomainsDocument gDoc = null;
    private JSONObject jsObj = null;
    private String emiVersionFile = "/etc/emi-version";
    public static final String SERVICE_TYPE = "eu.unicore.USE";

    public DomainsDocument generate(CIPProperties cfg, String unique) {
        Monitor m = cfg.getMonitor();
        String cipDataPath = cfg.getValue("dataPath");
        List<MonitoringEvent> events = m.getEvents("/", null, null, 1000);
        return this.generate(events, cipDataPath, unique);
    }

    public DomainsDocument generate(List<MonitoringEvent> events, String cipDataPath, String unique) {
        String jsonString = null;
        try {
            if (cipDataPath != null && cipDataPath != "") {
                jsonString = this.readFileAsString(cipDataPath);
                this.jsObj = new JSONObject(jsonString);
            } else {
                logger.debug((Object)"cip is null, creating default json info");
                this.jsObj = this.createDefaultJSON();
            }
            this.jsObj = this.jsObj.getJSONObject("unicore-site");
        }
        catch (IOException e1) {
            logger.warn((Object)"Cannot read CIP data file", (Throwable)e1);
        }
        catch (JSONException e) {
            logger.warn((Object)"invalid JSON file", (Throwable)e);
        }
        this.gDoc = DomainsDocument.Factory.newInstance();
        AdminDomainT adminT = this.gDoc.addNewDomains().addNewAdminDomain();
        adminT.setBaseType(this.getBaseType("Domain"));
        if (adminT.getID() == null) {
            adminT.setID("urn:unicore:ad:" + unique);
        }
        adminT.addNewComputingService().addNewComputingManager();
        ComputingServiceT csType = null;
        ComputingManagerT cmType = null;
        try {
            csType = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0);
            cmType = csType.getComputingManagerArray(0);
        }
        catch (Exception e) {
            csType = this.gDoc.addNewDomains().addNewAdminDomain().addNewComputingService();
            cmType = csType.addNewComputingManager();
        }
        if (csType.getID() == null) {
            csType.setID("urn:unicore:cs:" + unique);
        }
        csType.setBaseType(this.getBaseType("Service"));
        if (csType.getType() == null) {
            csType.setType(SERVICE_TYPE);
        }
        if (csType.getQualityLevel() == null) {
            csType.setQualityLevel(QualityLevelT.PRODUCTION);
        }
        if (cmType.getID() == null) {
            cmType.setID("urn:unicore:cm:" + unique);
        }
        cmType.setBaseType(this.getBaseType("Manager"));
        if (cmType.getProductName() == null) {
            cmType.setProductName("unicore/x");
        }
        for (MonitoringEvent monitoringEvent : events) {
            this.setEndpointInfo(monitoringEvent, unique);
            this.setExecutionEnvironment(monitoringEvent);
            this.setApplications(monitoringEvent);
            this.setJobs(monitoringEvent);
            this.setExtensions(monitoringEvent);
        }
        this.setLocationInformation(unique);
        this.setStorageInformation(unique);
        this.setDowntimeInformation();
        return this.gDoc;
    }

    private JSONObject createDefaultJSON() {
        JSONObject jsonObject = null;
        try {
            jsonObject = new JSONObject("{\"unicore-site\":{\"location\":{\"longitude\":55,\"latitude\":2,\"city\":\"city_name\",\"country\":\"country\",\"name\":\"fzj-demo-site\"},\"storage\":{\"total-capacity\":1024},\"compute\":{\"platform\":\"x86\"}}}");
        }
        catch (JSONException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return jsonObject;
    }

    private void setDowntimeInformation() {
        ComputingEndpointT ceT = null;
        JSONObject jsDowntime = null;
        try {
            ceT = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0).getComputingEndpointArray(0);
        }
        catch (IndexOutOfBoundsException e) {
            ceT = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0).addNewComputingEndpoint();
        }
        try {
            jsDowntime = this.jsObj.getJSONObject("downtime");
            String start = null;
            String end = null;
            String announce = null;
            String description = null;
            try {
                start = jsDowntime.getString("start");
                if (start != null) {
                    ceT.setDowntimeStart(DateUtil.toCalendar(start));
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                end = jsDowntime.getString("end");
                if (end != null) {
                    ceT.setDowntimeEnd(DateUtil.toCalendar(end));
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                announce = jsDowntime.getString("announce");
                if (announce != null) {
                    ceT.setDowntimeAnnounce(DateUtil.toCalendar(announce));
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
            try {
                description = jsDowntime.getString("description");
                if (description != null && ceT.isSetDowntimeInfo()) {
                    ceT.setDowntimeInfo(description);
                }
            }
            catch (JSONException e) {}
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void setStorageInformation(String unique) {
        StorageServiceCapacityT scT;
        StorageServiceT ssT;
        block7: {
            ssT = null;
            scT = null;
            try {
                ssT = this.gDoc.getDomains().getAdminDomainArray(0).getStorageServiceArray(0);
            }
            catch (IndexOutOfBoundsException e) {
                if (ssT != null) break block7;
                ssT = this.gDoc.getDomains().getAdminDomainArray(0).addNewStorageService();
            }
        }
        ssT.setID("urn:unicore:storageservice:" + unique);
        ssT.setBaseType(this.getBaseType("Service"));
        ssT.setType(SERVICE_TYPE);
        ssT.setQualityLevel(QualityLevelT.PRODUCTION);
        try {
            scT = ssT.getStorageServiceCapacityArray(0);
        }
        catch (IndexOutOfBoundsException e) {
            scT = ssT.addNewStorageServiceCapacity();
        }
        scT.setID("urn:unicore.sc1");
        scT.setType("online");
        try {
            String capacity;
            JSONObject jsStorageObj = this.jsObj.getJSONObject("storage");
            if (jsStorageObj != null && (capacity = jsStorageObj.getString("total-capacity")) != null) {
                BigInteger bi = new BigInteger(capacity);
                scT.setTotalSize(bi);
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
    }

    private void setExtensions(MonitoringEvent monitoringEvent) {
        ExtensionsT extsT = null;
        if (this.gDoc.getDomains().getAdminDomainArray(0).getExtensions() == null) {
            TextInfoType[] txtInfoTypeArr;
            extsT = this.gDoc.getDomains().getAdminDomainArray(0).addNewExtensions();
            if (monitoringEvent.getTopic().contains("/Text/General") && (txtInfoTypeArr = (TextInfoType[])monitoringEvent.getDetailsArray()) != null) {
                extsT = this.gDoc.getDomains().getAdminDomainArray(0).getExtensions();
                for (int i = 0; i < txtInfoTypeArr.length; ++i) {
                    ExtensionT extT = extsT.addNewExtension();
                    extT.setLocalID("one-more-random-glue2-field");
                    extT.setKey(txtInfoTypeArr[i].getName());
                    extT.setValue(txtInfoTypeArr[i].getValue());
                }
            }
            JSONObject jsExts = null;
            try {
                jsExts = this.jsObj.getJSONObject("extensions");
                if (jsExts != null) {
                    Iterator iterator = jsExts.sortedKeys();
                    while (iterator.hasNext()) {
                        String key = (String)iterator.next();
                        ExtensionT extT = extsT.addNewExtension();
                        extT.setLocalID("glue2-is-da-bomb");
                        extT.setKey(key);
                        extT.setValue(jsExts.getString(key));
                    }
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }

    private void setJobs(MonitoringEvent monitoringEvent) {
        if (monitoringEvent.getTopic().contains("/Jobs/General")) {
            JobsDocument jd = (JobsDocument)monitoringEvent.getDetails();
            ComputingServiceT csType = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0);
            csType.setTotalJobs(jd.getJobs().getTotalJobs().longValue());
            csType.setRunningJobs(jd.getJobs().getRunningJobs().longValue());
        }
    }

    private XmlAnySimpleType getBaseType(String typeName) {
        XmlAnySimpleType xasT = XmlAnySimpleType.Factory.newInstance();
        xasT.setStringValue(typeName);
        return xasT;
    }

    private void setExecutionEnvironment(MonitoringEvent monitoringEvent) {
        if (monitoringEvent.getTopic().contains("/Execution/General")) {
            ResourcesDocument rd = null;
            ResourcesType rt = null;
            try {
                rd = (ResourcesDocument)monitoringEvent.getDetails();
                rt = rd.getResources();
            }
            catch (Exception e) {
                logger.warn((Object)"error in getting resources' information from simple-idb");
                return;
            }
            ComputingManagerT cmType = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0).getComputingManagerArray(0);
            ExecutionEnvironmentT eEnvType = null;
            Double dPhysicalMemory = 0.0;
            try {
                eEnvType = cmType.isSetExecutionEnvironments() ? cmType.getExecutionEnvironments().getExecutionEnvironmentArray(0) : cmType.addNewExecutionEnvironments().addNewExecutionEnvironment();
            }
            catch (IndexOutOfBoundsException e) {
                eEnvType = cmType.addNewExecutionEnvironments().addNewExecutionEnvironment();
            }
            if (eEnvType.getPlatform() == null && rt.getCPUArchitecture().getCPUArchitectureName() != null) {
                eEnvType.setPlatform(rt.getCPUArchitecture().getCPUArchitectureName().toString());
            } else {
                eEnvType.setPlatform("x86");
            }
            if (!rt.isSetTotalPhysicalMemory()) {
                eEnvType.setMainMemorySize(BigInteger.valueOf(0L));
            } else {
                dPhysicalMemory = rt.getTotalPhysicalMemory().getRangeArray(0).getUpperBound().getDoubleValue();
                eEnvType.setMainMemorySize(BigInteger.valueOf(dPhysicalMemory.longValue()));
            }
            if (rt.isSetOperatingSystem()) {
                eEnvType.setOSFamily(rt.getOperatingSystem().getOperatingSystemType().getOperatingSystemName() != null ? rt.getOperatingSystem().getOperatingSystemType().getOperatingSystemName().toString() : "unknown");
                eEnvType.setOSName(rt.getOperatingSystem().getOperatingSystemType().getOperatingSystemName() != null ? rt.getOperatingSystem().getOperatingSystemType().getOperatingSystemName().toString() : "unknown");
                eEnvType.setOSVersion(rt.getOperatingSystem().getOperatingSystemVersion() != null ? rt.getOperatingSystem().getOperatingSystemVersion() : "0");
            } else {
                eEnvType.setOSFamily("unknown");
            }
            eEnvType.setConnectivityIn(ExtendedBooleanT.FALSE);
            eEnvType.setConnectivityOut(ExtendedBooleanT.FALSE);
            eEnvType.setBaseType(this.getBaseType("Resource"));
            eEnvType.setID("urn:unicore.ee1");
            Long totalPhysicalCPU = this.getTotalCPUCount(rt);
            Long tmpPhysicalCPUs = eEnvType.getPhysicalCPUs();
            if (tmpPhysicalCPUs != null) {
                eEnvType.setPhysicalCPUs(totalPhysicalCPU.longValue());
            }
            try {
                Long clockSpeed = this.jsObj.getJSONObject("compute").getLong("cpu-clock-speed");
                if (clockSpeed != null) {
                    eEnvType.setCPUClockSpeed(this.jsObj.getJSONObject("compute").getLong("cpu-clock-speed"));
                }
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
    }

    private Long getTotalCPUCount(ResourcesType rt) {
        Double dIndividualCPU = 0.0;
        Double dTotalResCount = 0.0;
        Long totalCPUCount = 0L;
        try {
            dIndividualCPU = rt.getIndividualCPUCount().getRangeArray(0).getUpperBound().getDoubleValue();
            dTotalResCount = rt.getTotalResourceCount().getRangeArray(0).getUpperBound().getDoubleValue();
            totalCPUCount = dIndividualCPU.longValue() * dTotalResCount.longValue();
        }
        catch (Exception e) {
            return 0L;
        }
        return totalCPUCount;
    }

    private void setApplications(MonitoringEvent monitoringEvent) {
        ApplicationType[] jsdlAppArr;
        if (monitoringEvent.getTopic().contains("/Applications/General") && (jsdlAppArr = (ApplicationType[])monitoringEvent.getDetailsArray()) != null) {
            ComputingManagerT cmType = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0).getComputingManagerArray(0);
            ApplicationEnvironmentsDocument.ApplicationEnvironments appEnvsType = cmType.getApplicationEnvironments();
            if (appEnvsType == null) {
                appEnvsType = cmType.addNewApplicationEnvironments();
            }
            for (int i = 0; i < jsdlAppArr.length; ++i) {
                ApplicationEnvironmentT appEnv = appEnvsType.addNewApplicationEnvironment();
                appEnv.setID(jsdlAppArr[i].getApplicationName().replaceAll(" ", "") + "_" + jsdlAppArr[i].getApplicationVersion());
                jsdlAppArr[i].getApplicationVersion();
                appEnv.setName(jsdlAppArr[i].getApplicationName());
                appEnv.setAppVersion(jsdlAppArr[i].getApplicationVersion());
            }
        }
    }

    private void setEndpointInfo(MonitoringEvent monitoringEvent, String unique) {
        if (monitoringEvent.getTopic().contains("/Site/General")) {
            SiteDocument sd = (SiteDocument)monitoringEvent.getDetails();
            ComputingServiceT csType = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0);
            ComputingEndpointT ceType = null;
            ceType = csType.getComputingEndpointArray().length > 0 ? csType.getComputingEndpointArray(0) : csType.addNewComputingEndpoint();
            if (ceType.getID() == null) {
                ceType.setID("urn:unicore:ce:" + unique);
            }
            if (ceType.getName() == null || ceType.getInterfaceName() == null) {
                if (sd.getSite().getName() != null) {
                    ceType.setName(sd.getSite().getName());
                    ceType.setInterfaceName(sd.getSite().getName());
                } else {
                    ceType.setName("unknown");
                    ceType.setInterfaceName("unknown");
                }
            }
            if (ceType.getQualityLevel() == null) {
                ceType.setQualityLevel(QualityLevelT.PRODUCTION);
            }
            if (ceType.getURL() == null) {
                if (sd.getSite().getURL() != null) {
                    ceType.setURL(sd.getSite().getURL());
                } else {
                    ceType.setURL("http://localhost");
                }
            }
            if (ceType.getHealthState() == null) {
                ceType.setHealthState(EndpointHealthStateT.OK);
            }
            if (ceType.getServingState() == null) {
                ceType.setServingState(ServingStateT.PRODUCTION);
            }
            if (ceType.getTechnology() == null) {
                ceType.setTechnology("webservice");
            }
            ceType.setBaseType(this.getBaseType("Endpoint"));
            this.setVersionInformation(ceType);
        }
    }

    private void setLocationInformation(String unique) {
        ComputingServiceT csT = this.gDoc.getDomains().getAdminDomainArray(0).getComputingServiceArray(0);
        LocationT locT = csT.getLocation();
        if (locT == null) {
            locT = csT.addNewLocation();
            locT.setID("urn:unicore:loc:" + unique);
            try {
                JSONObject locObj = this.jsObj.getJSONObject("location");
                if (locObj != null) {
                    locT.setLongitude(Float.valueOf(locObj.getString("longitude")).floatValue());
                    locT.setLatitude(Float.valueOf(locObj.getString("latitude")).floatValue());
                    locT.setCountry(locObj.getString("country"));
                    locT.setPlace(locObj.getString("city"));
                    locT.setName(locObj.getString("name"));
                }
            }
            catch (JSONException e) {
                logger.warn((Object)"Error in reading 'location' property from cipjson file", (Throwable)e);
                locT.setLongitude(52.0f);
                locT.setLatitude(3.0f);
                locT.setCountry("Germany");
                locT.setPlace("J\u00fclich");
                locT.setName("FZJ Demo Site");
            }
        }
    }

    private void setVersionInformation(ComputingEndpointT endpoint) {
        String uVersion = this.getClass().getPackage().getSpecificationVersion();
        if (uVersion == null) {
            uVersion = "DEVELOPMENT";
        }
        endpoint.addInterfaceVersion(uVersion);
        endpoint.setImplementationName("UNICORE");
        endpoint.setImplementationVersion(uVersion);
        endpoint.setInterfaceName("UNICORE");
        File emiFile = new File(this.emiVersionFile);
        if (emiFile.exists() && emiFile.canRead()) {
            try {
                String emiVersion = FileUtils.readFileToString((File)emiFile);
                endpoint.addOtherInfo("MiddlewareName=EMI");
                endpoint.addOtherInfo("MiddlewareVersion=" + emiVersion);
            }
            catch (IOException ex) {
                logger.trace((Object)"Can't read emi version.", (Throwable)ex);
            }
        }
    }

    private String readFileAsString(String filePath) throws IOException {
        return FileUtils.readFileToString((File)new File(filePath));
    }

    void setVersionFile(String fileName) {
        this.emiVersionFile = fileName;
    }
}

