/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.impl.DefaultEventConverter;
import de.fzj.unicore.wsrflite.Kernel;
import java.util.Calendar;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.w3.x2005.atom.EntryType;
import org.w3.x2005.atom.FeedDocument;
import org.w3.x2005.atom.FeedType;

public class FeedGenerator {
    private FeedGenerator() {
    }

    public static FeedDocument generateFeed(List<MonitoringEvent> events, Kernel kernel) {
        return FeedGenerator.generateFeed(events, new DefaultEventConverter(), kernel);
    }

    public static FeedDocument generateFeed(List<MonitoringEvent> events, EventToFeedEntryConverter conv, Kernel kernel) {
        FeedDocument f = FeedDocument.Factory.newInstance();
        FeedType ft = f.addNewFeed();
        XmlString t = XmlString.Factory.newInstance();
        t.setStringValue("Feed generated by UNICORE CIS InfoProvider");
        ft.addNewTitle().set((XmlObject)t);
        ft.addNewUpdated().setCalendarValue(Calendar.getInstance());
        ft.addNewId().setStringValue(kernel.getContainerProperties().getBaseUrl());
        for (MonitoringEvent e : events) {
            ft.addNewEntry().set((XmlObject)conv.createFeedEntry(e, kernel));
        }
        return f;
    }

    public static interface EventToFeedEntryConverter {
        public EntryType createFeedEntry(MonitoringEvent var1, Kernel var2);
    }
}

