/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.MonitorEventListener;
import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.Sensor;
import de.fzj.unicore.cisprovider.jmx.SensorJMX;
import de.fzj.unicore.uas.util.LogUtil;
import de.fzj.unicore.wsrflite.Kernel;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DefaultSensor
implements Sensor {
    protected static final Logger logger = LogUtil.getLogger((String)"unicore.services", DefaultSensor.class);
    protected final List<MonitorEventListener> listeners = new ArrayList<MonitorEventListener>();
    private MonitoringEvent lastEvent;
    private int notifications;
    private int updates;
    protected final Kernel kernel;

    public DefaultSensor(Kernel kernel) {
        this.kernel = kernel;
        this.initJMX();
    }

    public abstract String getName();

    protected void initJMX() {
        logger.info((Object)("Registering JMX bean for " + this.getName()));
        Kernel.addMBean((Object)new SensorJMX(this), (String)("InfoProviderSensor<" + this.getName() + ">"));
    }

    @Override
    public void addEventListener(MonitorEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public MonitoringEvent getLastEvent() {
        return this.lastEvent;
    }

    @Override
    public void removeEventListener(MonitorEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void doNotify() {
        for (MonitorEventListener l : this.listeners) {
            l.notify(this.getLastEvent());
        }
        ++this.notifications;
    }

    protected void setLastEvent(MonitoringEvent e) {
        this.lastEvent = e;
        ++this.updates;
    }

    public int getNumberOfNotificationsSent() {
        return this.notifications;
    }

    public int getNumberOfUpdates() {
        return this.updates;
    }

    public void clearStatistics() {
        this.updates = 0;
        this.notifications = 0;
    }
}

