/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.MonitorEventListener;
import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.Sensor;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefaultMonitor
implements Monitor,
MonitorEventListener {
    private static Logger logger = Logger.getLogger((String)DefaultMonitor.class.getName());
    private Set<Sensor> sensors = new HashSet<Sensor>();
    private Map<String, MonitoringEvent> events = new HashMap<String, MonitoringEvent>();

    @Override
    public void addSensor(Sensor sensor) {
        sensor.addEventListener(this);
        this.sensors.add(sensor);
    }

    @Override
    public void removeSensor(Sensor sensor) {
        this.sensors.remove(sensor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MonitoringEvent> getEvents(String topic, Calendar from, Calendar to, int limit) {
        ArrayList<MonitoringEvent> ev = new ArrayList<MonitoringEvent>();
        Map<String, MonitoringEvent> map = this.events;
        synchronized (map) {
            int i = 0;
            if (limit <= 0) {
                ev.addAll(this.events.values());
            } else {
                for (MonitoringEvent e : this.events.values()) {
                    if (to != null && to.before(e.getTime()) || from != null && from.after(e.getTime())) continue;
                    if (e.matchesTopic(topic)) {
                        ev.add(e);
                        ++i;
                    }
                    if (i < limit) continue;
                    break;
                }
            }
            for (Sensor s : this.sensors) {
                if (i >= limit) break;
                MonitoringEvent e = s.getLastEvent();
                if (e != null && !ev.contains(e) && e.matchesTopic(topic)) {
                    ev.add(e);
                }
                ++i;
            }
        }
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(MonitoringEvent event) {
        Map<String, MonitoringEvent> map = this.events;
        synchronized (map) {
            String supersedes;
            String id = event.getID();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Notification for event <" + id + "> on " + event.getTopic()));
            }
            if ((supersedes = event.supersedes()) != null) {
                logger.debug((Object)("Removing <" + supersedes + "> superseded by <" + id + ">"));
                this.events.remove(supersedes);
            }
            this.events.put(id, event);
        }
    }
}

