/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider.impl;

import de.fzj.unicore.cisprovider.CIPProperties;
import de.fzj.unicore.cisprovider.CISInfoProvider;
import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.MonitoringEvent;
import de.fzj.unicore.cisprovider.ServiceInfoGenerator;
import de.fzj.unicore.cisprovider.impl.FeedGenerator;
import de.fzj.unicore.cisprovider.impl.GlueInstanceGenerator;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetGlueInfoResponseDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetInfoResponseDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoRequestDocument;
import de.fzj.unicore.cisprovider.xmlbeans.GetServiceInfoResponseDocument;
import de.fzj.unicore.wsrflite.Kernel;
import de.fzj.unicore.wsrflite.KernelInjectable;
import de.fzj.unicore.wsrflite.xmlbeans.BaseFault;
import eu.unicore.util.Log;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.ogf.schemas.glue.x2009.x03.spec20R1.DomainsDocument;
import org.ogf.schemas.glue.x2009.x03.spec20R1.ServiceT;

public class CISInfoProviderImpl
implements CISInfoProvider,
KernelInjectable {
    static final Logger logger = Log.getLogger((String)"unicore.services", CISInfoProvider.class);
    private Kernel kernel;

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public GetInfoResponseDocument getInfo(GetInfoRequestDocument request) {
        try {
            CIPProperties cfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
            Monitor m = cfg.getMonitor();
            String topic = request.getGetInfoRequest().getTopic();
            Calendar from = request.getGetInfoRequest().getFrom();
            Calendar to = request.getGetInfoRequest().getTo();
            BigInteger requestedLimit = request.getGetInfoRequest().getMaxNumberOfRecords();
            int limit = 100;
            if (requestedLimit != null) {
                limit = requestedLimit.intValue();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Request: topic=" + topic + ", from=" + from + ", to=" + to + ", limit=" + limit));
            }
            List<MonitoringEvent> list = m.getEvents(topic, from, to, limit);
            GetInfoResponseDocument res = GetInfoResponseDocument.Factory.newInstance();
            res.addNewGetInfoResponse().setFeed(FeedGenerator.generateFeed(list, this.kernel).getFeed());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Response: " + res));
            }
            return res;
        }
        catch (Exception e) {
            Log.logException((String)"Error processing request.", (Throwable)e, (Logger)logger);
            throw new RuntimeException(e);
        }
    }

    public GetGlueInfoResponseDocument getGlueInfo(GetGlueInfoRequestDocument req) throws BaseFault {
        CIPProperties cfg = (CIPProperties)((Object)this.kernel.getAttribute(CIPProperties.class));
        GetGlueInfoResponseDocument res = GetGlueInfoResponseDocument.Factory.newInstance();
        try {
            GetGlueInfoResponseDocument.GetGlueInfoResponse resType = res.addNewGetGlueInfoResponse();
            resType.addNewDomains();
            String unique = this.kernel.getContainerProperties().getBaseUrl();
            DomainsDocument gDoc = new GlueInstanceGenerator().generate(cfg, unique);
            resType.setDomains(gDoc.getDomains());
        }
        catch (Exception e) {
            Log.logException((String)"Error processing request.", (Throwable)e, (Logger)logger);
            throw BaseFault.createFault((String)"Error processing request.", (Throwable)e);
        }
        return res;
    }

    public GetServiceInfoResponseDocument getServiceInfo(GetServiceInfoRequestDocument req) throws BaseFault {
        GetServiceInfoResponseDocument res = GetServiceInfoResponseDocument.Factory.newInstance();
        ServiceT[] arrServiceT = ServiceInfoGenerator.getServiceInformation(this.kernel).toArray(new ServiceT[0]);
        res.addNewGetServiceInfoResponse().setServiceArray(arrServiceT);
        return res;
    }
}

