/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.cisprovider;

import de.fzj.unicore.cisprovider.Monitor;
import de.fzj.unicore.cisprovider.impl.DefaultMonitor;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import eu.unicore.util.configuration.DocumentationReferenceMeta;
import eu.unicore.util.configuration.DocumentationReferencePrefix;
import eu.unicore.util.configuration.PropertiesHelper;
import eu.unicore.util.configuration.PropertyMD;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CIPProperties
extends PropertiesHelper {
    private static final Logger log = Log.getLogger((String)"unicore.services", CIPProperties.class);
    @DocumentationReferencePrefix
    public static final String PREFIX = "coreServices.cip.";
    public static final String LATITUDE = "site.latitude";
    public static final String LONGITUDE = "site.longitude";
    public static final String NUM_CPUS = "site.cpus";
    public static final String NAME = "site.name";
    public static final String DESCRIPTION = "site.description";
    public static final String URL = "site.url";
    public static final String GLUE2_GENERATE = "glue2.generate";
    public static final String GLUE2_TARGET = "glue2.targetPath";
    public static final String GLUE2_REFRESHPERIOD = "glue2.refreshPeriod";
    public static final String DATA_PATH = "dataPath";
    public static final String PUBLISH = "publish";
    private DefaultMonitor defMon = new DefaultMonitor();
    @DocumentationReferenceMeta
    public static final Map<String, PropertyMD> META = new HashMap<String, PropertyMD>();

    public CIPProperties(Properties properties) throws ConfigurationException {
        super(PREFIX, properties, META, log);
    }

    public Monitor getMonitor() {
        return this.defMon;
    }

    static {
        META.put(LATITUDE, new PropertyMD("50.94545").setDescription("Geographical latitude of the site"));
        META.put(LONGITUDE, new PropertyMD("6.377907").setDescription("Geographical longitude of the site"));
        META.put(NUM_CPUS, new PropertyMD("1").setDescription("Number of CPUs the site provides"));
        META.put(NAME, new PropertyMD().setDescription("Site name"));
        META.put(DESCRIPTION, new PropertyMD("Linux server").setDescription("Site description"));
        META.put(URL, new PropertyMD().setDescription("Site web URL"));
        META.put(GLUE2_GENERATE, new PropertyMD("false").setBoolean().setDescription("Whether to auto-generate a GLUE2 document"));
        META.put(GLUE2_TARGET, new PropertyMD("/var/run/unicore/unicorex_glue2.xml").setDescription("Path for the auto-generated GLUE2 document"));
        META.put(GLUE2_REFRESHPERIOD, new PropertyMD("3600").setLong().setDescription("Refresh period (in seconds) for the GLUE2. If <0, no refresh will be done"));
        META.put(DATA_PATH, new PropertyMD("conf/site-info.json").setPath().setDescription("Path to the JSON file with constant information about the service."));
        META.put(PUBLISH, new PropertyMD("true").setDescription("Controls whether CIP service endpoint information should be published to registry."));
    }
}

