/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.index;

import de.fzj.unicore.persist.index.FieldIndexer;
import de.fzj.unicore.persist.index.IndexEntryBuilder;
import de.fzj.unicore.persist.index.Indexed;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PropertyIndexer
implements IndexEntryBuilder {
    private static final Logger logger = Logger.getLogger((String)("unicore.persistence." + PropertyIndexer.class.getSimpleName()));

    @Override
    public Map<String, String> getIndexEntry(Object dao) {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            for (Field f : dao.getClass().getDeclaredFields()) {
                Indexed indexed = f.getAnnotation(Indexed.class);
                if (indexed == null) continue;
                Class<? extends FieldIndexer> indexerClass = indexed.indexer();
                FieldIndexer indexer = indexerClass.newInstance();
                String name = indexer.getName(f, dao);
                String value = indexer.getValue(f, dao);
                result.put(name, value);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error creating index data", (Throwable)ex);
        }
        return result;
    }
}

