/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.impl.ClassScanner;
import de.fzj.unicore.persist.impl.ColumnDescriptor;
import de.fzj.unicore.persist.index.IndexEntryBuilder;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistenceDescriptor {
    private String tableName;
    private Method getIdMethod;
    private List<ColumnDescriptor> columns;
    private Map<String, ColumnDescriptor> columnMap;
    private IndexEntryBuilder ieb;

    public static PersistenceDescriptor get(Class<?> daoClass) {
        PersistenceDescriptor pd = new PersistenceDescriptor();
        pd.setTableName(ClassScanner.getTableName(daoClass));
        pd.getIdMethod = ClassScanner.getGetIdMethod(daoClass);
        pd.setColumns(ClassScanner.getColumns(daoClass));
        pd.columnMap = new HashMap<String, ColumnDescriptor>();
        if (pd.columns != null) {
            for (ColumnDescriptor c : pd.columns) {
                pd.columnMap.put(c.getColumn(), c);
            }
        }
        pd.ieb = ClassScanner.getIndexEntryBuilder(daoClass);
        return pd;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getID(Object dao) throws PersistenceException {
        try {
            return this.getIdMethod.invoke(dao, (Object[])null).toString();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public List<ColumnDescriptor> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnDescriptor> columns) {
        this.columns = columns;
    }

    public String getColumnValue(String columnName, Object dao) throws PersistenceException {
        try {
            return (String)this.columnMap.get(columnName).getMethod().invoke(dao, (Object[])null);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public IndexEntryBuilder getIndexEntryBuilder() {
        return this.ieb;
    }
}

