/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.cluster.Cluster;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LockSupport {
    private final Map<String, Lock> locks;
    private boolean distributed = false;
    private String clusterConfig = null;
    private Cluster cluster;
    private final String tableName;

    public LockSupport(boolean tryDistributed, String tableName) {
        this.locks = new HashMap<String, Lock>();
        this.distributed = tryDistributed;
        this.tableName = tableName;
        if (this.distributed) {
            this.setupDistributedMode();
        }
    }

    public LockSupport(String clusterConfigFile, String tableName) {
        this.clusterConfig = clusterConfigFile;
        this.locks = new ConcurrentHashMap<String, Lock>();
        this.distributed = true;
        this.tableName = tableName;
        this.setupDistributedMode();
    }

    public final synchronized Lock getOrCreateLock(String id) {
        String key = this.tableName + id;
        Lock l = this.locks.get(key);
        if (l == null) {
            l = this.distributed ? this.createDistributedLock(key) : this.createLock(key);
        }
        this.locks.put(key, l);
        return l;
    }

    public final synchronized Lock getLockIfExists(String id) {
        String key = this.tableName + id;
        return this.locks.get(key);
    }

    private void setupDistributedMode() {
        try {
            this.cluster = this.clusterConfig != null ? Cluster.getInstance(this.clusterConfig) : Cluster.getDefaultInstance();
            this.distributed = this.cluster != null;
        }
        catch (Exception ex) {
            this.distributed = false;
        }
    }

    private Lock createLock(String id) {
        Lock l = this.locks.get(id);
        if (l == null) {
            l = new ReentrantLock(true);
        }
        return l;
    }

    public synchronized boolean cleanup(String id) {
        String key;
        Lock l = this.getLockIfExists(id);
        if (l != null) {
            try {
                l.unlock();
            }
            catch (IllegalMonitorStateException me) {
                // empty catch block
            }
        }
        return this.locks.remove(key = this.tableName + id) != null;
    }

    public synchronized void cleanup() {
        this.locks.clear();
    }

    public String getClusterConfig() {
        return this.clusterConfig;
    }

    private Lock createDistributedLock(String id) {
        return this.cluster.getLock(id);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
        if (cluster != null) {
            this.distributed = true;
        }
    }
}

