/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.impl.DeserialisationErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;

public class CustomObjectInputStream
extends ObjectInputStream {
    private final ClassLoader classLoader;
    private final DeserialisationErrorHandler errorHandler;

    public CustomObjectInputStream(InputStream input, ClassLoader classLoader, DeserialisationErrorHandler errorHandler) throws IOException, SecurityException {
        super(input);
        this.classLoader = classLoader;
        this.errorHandler = errorHandler;
        if (errorHandler != null) {
            errorHandler.clearErrors();
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            if (this.classLoader != null) {
                return Class.forName(desc.getName(), true, this.classLoader);
            }
            return Class.forName(desc.getName());
        }
        catch (ClassNotFoundException cfe) {
            if (this.errorHandler == null) {
                throw cfe;
            }
            try {
                Long serial = 1L;
                Class<Object> replacement = this.errorHandler.notifyClassNotFound(desc.getName());
                if (replacement == null) {
                    replacement = PlaceHolder.class;
                }
                try {
                    Field ser = replacement.getDeclaredField("serialVersionUID");
                    if (ser != null) {
                        ser.setAccessible(true);
                        serial = ser.getLong(null);
                    }
                    Field f = ObjectStreamClass.class.getDeclaredField("suid");
                    f.setAccessible(true);
                    f.set(desc, serial);
                    Field f2 = ObjectStreamClass.class.getDeclaredField("name");
                    f2.setAccessible(true);
                    f2.set(desc, replacement.getName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                return replacement != null ? replacement : PlaceHolder.class;
            }
            catch (Exception ex) {
                throw cfe;
            }
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass osc = super.readClassDescriptor();
        return osc;
    }

    public static class PlaceHolder
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }
}

