/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.util.Pool;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ConnectionPool {
    private static final Logger logger = Logger.getLogger((String)"unicore.persistence.ConnectionPool");
    Pool pool;
    private Connection theConnection;

    protected void setupConnectionPool(ConnectionPoolDataSource ds, int max_connections, int timeout, DataSource dataSource) throws PersistenceException {
        if (ds == null && dataSource == null) {
            throw new IllegalStateException("Must have either ConnectionPoolDataSource or normal DataSource!");
        }
        if (ds != null) {
            this.pool = new Pool(ds, max_connections, timeout);
            logger.info((Object)("Connection pooling enabled, maxConnections=" + max_connections + " timeout=" + timeout));
        } else {
            try {
                this.theConnection = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
    }

    protected synchronized Connection getConnection() throws PersistenceException {
        if (this.theConnection != null) {
            return this.theConnection;
        }
        try {
            return this.pool.getConnection();
        }
        catch (SQLException se) {
            throw new PersistenceException(se);
        }
    }

    protected void disposeConnection(Connection conn) {
        if (this.theConnection != null) {
            return;
        }
        try {
            if (!conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException se) {
            logger.error((Object)"Error closing connection.", (Throwable)se);
        }
    }

    protected void shutdownPool() throws PersistenceException {
        if (this.theConnection != null) {
            return;
        }
        try {
            this.pool.dispose();
        }
        catch (SQLException se) {
            throw new PersistenceException(se);
        }
    }
}

