/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.impl;

import de.fzj.unicore.persist.annotations.Column;
import de.fzj.unicore.persist.annotations.ID;
import de.fzj.unicore.persist.annotations.Table;
import de.fzj.unicore.persist.impl.ColumnDescriptor;
import de.fzj.unicore.persist.index.IndexEntryBuilder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class ClassScanner {
    private ClassScanner() {
    }

    public static String getTableName(Class<?> daoClass) {
        if (daoClass.getAnnotation(Table.class) != null) {
            return daoClass.getAnnotation(Table.class).name();
        }
        return daoClass.getSimpleName();
    }

    public static Method getGetIdMethod(Class<?> daoClass) {
        for (Method method : daoClass.getDeclaredMethods()) {
            if (method.getAnnotation(ID.class) == null) continue;
            if (!String.class.equals(method.getReturnType())) {
                throw new IllegalArgumentException("ID method must return java.lang.String");
            }
            return method;
        }
        for (AccessibleObject accessibleObject : daoClass.getDeclaredFields()) {
            String name;
            Method m;
            if (((Field)accessibleObject).getAnnotation(ID.class) == null || (m = ClassScanner.findMethod(daoClass, name = "get" + ((Field)accessibleObject).getName())) == null) continue;
            if (!String.class.equals(m.getReturnType())) {
                throw new IllegalArgumentException("ID method must return java.lang.String");
            }
            return m;
        }
        throw new IllegalArgumentException("Class has no useable ID annotation!");
    }

    public static List<ColumnDescriptor> getColumns(Class<?> daoClass) {
        String name;
        ArrayList<ColumnDescriptor> result = new ArrayList<ColumnDescriptor>();
        for (Method method : daoClass.getDeclaredMethods()) {
            if (method.getAnnotation(Column.class) == null) continue;
            name = method.getAnnotation(Column.class).name();
            ColumnDescriptor cd = new ColumnDescriptor(method, name);
            result.add(cd);
        }
        for (AccessibleObject accessibleObject : daoClass.getDeclaredFields()) {
            if (((Field)accessibleObject).getAnnotation(Column.class) == null) continue;
            name = "get" + ((Field)accessibleObject).getName();
            Method m = ClassScanner.findMethod(daoClass, name);
            if (m == null) {
                throw new IllegalArgumentException("Can't find getter method for column " + ((Field)accessibleObject).getName());
            }
            String columnName = ((Field)accessibleObject).getAnnotation(Column.class).name();
            if (columnName == null) {
                columnName = ((Field)accessibleObject).getName();
            }
            ColumnDescriptor cd = new ColumnDescriptor(m, columnName);
            result.add(cd);
        }
        return result.size() != 0 ? result : null;
    }

    private static Method findMethod(Class<?> daoClass, String name) {
        for (Method m : daoClass.getDeclaredMethods()) {
            if (!m.getName().equalsIgnoreCase(name)) continue;
            return m;
        }
        return null;
    }

    public static IndexEntryBuilder getIndexEntryBuilder(Class<?> daoClass) {
        return null;
    }
}

