/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist.cluster;

import com.hazelcast.config.Config;
import com.hazelcast.config.FileSystemXmlConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;

public class Cluster {
    private static final Logger logger = Logger.getLogger((String)("unicore.persistence." + Cluster.class.getSimpleName()));
    private static Cluster theDefaultInstance = null;
    private final HazelcastInstance hazelcast;
    private static final Map<String, Cluster> instances = new HashMap<String, Cluster>();

    Cluster(HazelcastInstance hz) {
        this.hazelcast = hz;
    }

    Cluster(File configFile) throws FileNotFoundException {
        if (configFile == null) {
            this.hazelcast = Hazelcast.newHazelcastInstance(null);
            logger.info((Object)"Created cluster instance based on default configuration.");
        } else {
            FileSystemXmlConfig config = new FileSystemXmlConfig(configFile);
            this.hazelcast = Hazelcast.newHazelcastInstance((Config)config);
            logger.info((Object)("Created cluster instance based on configuration file " + configFile));
        }
    }

    public static synchronized Cluster getInstance(String configFile) throws FileNotFoundException {
        File f = new File(configFile);
        Cluster cluster = instances.get(f.getAbsolutePath());
        if (cluster == null) {
            cluster = new Cluster(f);
            instances.put(f.getAbsolutePath(), cluster);
        }
        return cluster;
    }

    public static synchronized Cluster getDefaultInstance() throws FileNotFoundException {
        if (theDefaultInstance == null) {
            String configFile = System.getProperty("persistence.cluster.config");
            if (configFile != null) {
                Cluster c;
                theDefaultInstance = c = Cluster.getInstance(configFile);
                logger.info((Object)("Created default cluster instance based on configuration file " + configFile));
            } else {
                logger.debug((Object)"Clustering disabled, set system property persistence.cluster.config to the location of the cluster config file.");
            }
        }
        return theDefaultInstance;
    }

    public Lock getLock(String key) {
        return this.hazelcast.getLock((Object)key);
    }

    public void shutdown() {
        this.hazelcast.shutdown();
    }

    public static void shutdownAll() {
        Hazelcast.shutdownAll();
    }
}

