/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.persist;

import de.fzj.unicore.persist.Persist;
import de.fzj.unicore.persist.PersistenceException;
import de.fzj.unicore.persist.PersistenceProperties;
import de.fzj.unicore.persist.impl.ClassScanner;
import de.fzj.unicore.persist.impl.H2Persist;
import de.fzj.unicore.persist.impl.PersistenceDescriptor;
import eu.unicore.util.Log;
import eu.unicore.util.configuration.ConfigurationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class PersistenceFactory {
    private static final Logger logger = Log.getLogger((String)"unicore.wsrflite.persistence", PersistenceFactory.class);
    private PersistenceProperties config;

    private PersistenceFactory() {
    }

    public PersistenceProperties getConfig() {
        return this.config;
    }

    public void setConfig(PersistenceProperties config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PersistenceFactory get(PersistenceProperties config) {
        File cFile;
        PersistenceFactory pf = new PersistenceFactory();
        File file = cFile = config == null ? null : config.getFileValue("config", false);
        if (cFile != null) {
            try {
                FileInputStream in = new FileInputStream(cFile);
                Properties props = new Properties();
                try {
                    props.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
                pf.config = new PersistenceProperties(props);
                logger.info((Object)("Reading persistence configuration from <" + cFile + ">"));
            }
            catch (IOException ex) {
                throw new ConfigurationException("Can't read properties file <" + cFile + ">", (Throwable)ex);
            }
        }
        pf.config = config;
        return pf;
    }

    public <T> Persist<T> getPersist(Class<T> daoClass) throws PersistenceException {
        try {
            return this.configurePersist(daoClass, this.getPersistClass(daoClass));
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public <T> Persist<T> getPersist(Class<T> daoClass, PersistenceDescriptor pd) throws PersistenceException {
        try {
            return this.configurePersist(daoClass, this.getPersistClass(daoClass), pd);
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    public <T> Persist<T> configurePersist(Class<T> daoClass, Class<? extends Persist<T>> implementation, PersistenceDescriptor pd) throws IllegalAccessException, InstantiationException, PersistenceException {
        Persist<T> p = implementation.newInstance();
        p.setConfigSource(this.config);
        p.setPersistenceDescriptor(pd);
        p.setDaoClass(daoClass);
        p.init();
        return p;
    }

    public <T> Persist<T> configurePersist(Class<T> daoClass, Class<? extends Persist<T>> implementation) throws IllegalAccessException, InstantiationException, PersistenceException {
        return this.configurePersist(daoClass, implementation, null);
    }

    protected <T> Class<? extends Persist<T>> getPersistClass(Class<T> daoClass) throws ClassNotFoundException {
        String tableName = ClassScanner.getTableName(daoClass);
        String clazz = this.config.getSubkeyValue("class", tableName);
        if (clazz == null) {
            clazz = H2Persist.class.getName();
        }
        Class<?> persistClazz = Class.forName(clazz);
        return persistClazz;
    }

    public static synchronized void registerMBean(Object mbean, String name) throws Exception {
        MBeanServer mbs = null;
        mbs = ManagementFactory.getPlatformMBeanServer();
        ObjectName adminName = null;
        adminName = new ObjectName("Persistence:name=" + name);
        if (mbs.queryMBeans(adminName, null).size() == 0) {
            mbs.registerMBean(mbean, adminName);
        }
    }
}

