import de.fzj.unicore.ucc.testsuite.UccCommand;
import de.fzj.unicore.ucc.testsuite.util.Utilities;
import de.fzj.unicore.ucc.testsuite.TestResult;
import de.fzj.unicore.ucc.testsuite.util.Reporting;

/*
* built-in groovy script which starts the testsuite
*/

def startTime=System.currentTimeMillis()
def startDate=new Date()

//which test to run
testSpec=commandLine.args[1]

//holder for logs from multiple runs

logs=[]

/**
* run a single test
*/
def runSingle(test)
{
   UccCommand cmd = new UccCommand(test)
   println("Running test "+test+": "+cmd.testDescription)

   //inject settings
   cmd.properties=properties
   cmd.commandLine=commandLine
   cmd.securityProperties=securityProperties
   
   logs+=cmd.run()
}

def runSuite(test)
{
    def base=new File(test).absoluteFile.parentFile.absolutePath
    println("\nStarting test suite: "+test+ " in base dir "+base)
    def tests = json.optJSONArray("Tests")
    for(int k=0; k<tests.length(); k++){
      it=tests.get(k)
      println it
      def testFile=it.optString("File")
      def instances=it.optInt("Instances",1)
 	  def singleTest=new File(base,testFile).absolutePath	 
		
		println "Running test: "+singleTest + " ("+instances+": instances)"
		
		for(i in 1..instances) {
			println("running instance: "+i+"/"+instances)
			runTest(singleTest)	
		}
		
    } 
}


def runTest(test)
{
	json=Utilities.createJsonObject(test);
	if("SingleTest"==json.optString("Type")){
   		runSingle(test)
	}
	else if("TestSuite"==json.optString("Type")){
		runSuite(test)	
	}
}

/**
 * extract some meta information from the testsuite
 */
json=Utilities.createJsonObject(testSpec)
def description=json.optString("Description")

/**
 * start processing the specified test
 */ 
runTest(testSpec)

/**
* reporting
*/
def successful=0
def failed=0
def totalTests=logs.size()

float totalTime=(System.currentTimeMillis()-startTime)/1000
println "***************"
println "*** Summary ***"
println "***************"
println ""
println "Testsuite <"+description+"> started at "+startDate
println ""

logs.each {
	println(it)
	if(it.success)successful++;
	else failed++
}

println "Total time: "+String.format("%.0f sec.", totalTime)
println "Total: "+totalTests+" successful: "+successful+" failed: "+failed

/**
 * generate html report
 */ 
report='test-results-'+new Date().format('yyyy-MM-dd_HH:mm')+'.html'
new File(report).withWriter{ writer ->
  def builder=new groovy.xml.MarkupBuilder(writer)
  Reporting.htmlReport(builder,description,logs)
 }
println "Wrote HTML report to '"+report+"'."
