/*
* list available storages 
*/
import de.fzj.unicore.uas.client.*
import javax.xml.namespace.QName

//porttype of storage service 
def SMSPORT=new QName("http://unigrids.org/2006/04/services/sms","StorageManagement")

//method to extract storage name from a storage client
def findName(epr){
  sms=new StorageClient(epr.address.stringValue, epr, securityProperties)
  return sms.resourcePropertiesDocument.storageProperties.fileSystem.name
}

//list storages from registry
registry.listAccessibleServices(SMSPORT).each { 
    name=findName(it)
    messageWriter.message "Storage <"+name+"> at "+it.address.stringValue			    
}

//list storages attached to target systems
def lister = new de.fzj.unicore.ucc.helpers.TargetSystemLister(registry,securityProperties,messageWriter)

lister.each { 
    it.storages.each{
        name=findName(it)
   	    messageWriter.message "Storage <"+name+"> at "+it.address.stringValue
    }
}
