/*
* kill all successful jobs
*
* run with 'ucc run-groovy -f killall.groovy ...'
* 
*/
import de.fzj.unicore.uas.client.*

def lister = new de.fzj.unicore.ucc.helpers.TargetSystemLister(registry,securityProperties,messageWriter)

def TSSPORT=new javax.xml.namespace.QName("http://unigrids.org/2006/04/services/tss","TargetSystem")
def TSFPORT=new javax.xml.namespace.QName("http://unigrids.org/2006/04/services/tsf","TargetSystemFactory")

//kills a job with the given status (SUCCESSFUL, RUNNING, ...)

def kill(job, statuscode){
 
  if (job.status.toString() == statuscode)job.destroy()  

}

//iterate over TSSs and kill all jobs that are "SUCCESSFUL"

registry.listServices(TSFPORT).each { 
   def tsf=new TSFClient(it.address.stringValue, it, securityProperties)
   
   tsf.accessibleTargetSystems.each{
     println "Site: "+it.address.stringValue
     def tss=new TSSClient(it.address.stringValue, it, securityProperties)
       tss.jobs.each{
   	   println "  Job: "+it.address.stringValue
           kill(new JobClient(it.address.stringValue, it, securityProperties),"SUCCESSFUL")
     }
   }
}
