/*
 * Decompiled with CFR 0.152.
 */
package de.fzj.unicore.ucc.bes;

import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.ucc.bes.BaseActionState;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivitiesResponseType;
import org.ggf.schemas.bes.x2006.x08.besFactory.TerminateActivityResponseType;

public class TerminateJob
extends BaseActionState {
    @Override
    public void process() {
        super.process();
        this.terminate();
    }

    public String getName() {
        return "bes-terminate-job";
    }

    public String getArgumentList() {
        return "<jobfile>";
    }

    public String getSynopsis() {
        return "Terminate BES job using a job properties file.";
    }

    public String getDescription() {
        return "terminate bes activity";
    }

    @Override
    protected void terminate() {
        TerminateActivitiesResponseType termType = null;
        try {
            termType = this.factory.terminateActivity(this.activityEpr);
        }
        catch (UnknownActivityIdentifierFault e) {
            this.error("Couldn't find the specified activity. ", e);
            this.endProcessing();
        }
        StringBuilder sb = new StringBuilder();
        TerminateActivityResponseType tt = termType.getResponseArray()[0];
        if (tt.getTerminated()) {
            sb.append("Job is cancelled.");
        } else if (tt.getFault() != null) {
            sb.append(termType.getResponseArray()[0].getFault().getFaultstring());
        } else {
            sb.append("Job will eventually be cancelled.");
        }
        this.message(sb.toString());
    }

    public String getCommandGroup() {
        return "OGSA-BES";
    }
}

